import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_center/widget/result_layout.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:flutter/material.dart';

class PeopleIdentityStatusPage extends StatelessWidget {
  final PeopleIdentityStatus status;
  final String failedReason;

  const PeopleIdentityStatusPage(this.status,
      {super.key, this.failedReason = ''});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: MyAppBar('实名认证'),
        body: Container(
          margin: EdgeInsets.only(top: 10),
          child: ResultLayout(
            title: _statusMessage(),
            secondTitle: _getTip(),
            icon: _getIcon(),
            buttonText: _getButtonText(),
            onTap: () {
              if (status == PeopleIdentityStatus.doing) {
                Get.back();
              } else if (status == PeopleIdentityStatus.failed) {
                Get.offNamed(RouteConfig.identityUserIdCardPage);
              } else if (status == PeopleIdentityStatus.success) {
                Get.offNamed(RouteConfig.identityUserIdCardPage);
              }
            },
          ),
        ));
  }

  String _statusMessage() {
    switch (status) {
      case PeopleIdentityStatus.doing:
        return '人工审核中';
      case PeopleIdentityStatus.success:
        return '人工审核已通过';
      case PeopleIdentityStatus.failed:
        return '人工审核未通过';
      default:
        return '人工审核中';
    }
  }

  String _getIcon() {
    switch (status) {
      case PeopleIdentityStatus.doing:
        return 'circle_normal';
      case PeopleIdentityStatus.success:
        return 'circle_success';
      case PeopleIdentityStatus.failed:
        return 'circle_failed';
      default:
        return 'circle_doing';
    }
  }

  String _getTip() {
    switch (status) {
      case PeopleIdentityStatus.doing:
        return '我们将在1-2个工作日内，完成审核，请耐心等待';
      case PeopleIdentityStatus.success:
        return '恭喜您信息审核通过，请继续完成下一步操作';
      case PeopleIdentityStatus.failed:
        return failedReason;
      default:
        return '认证中，请耐心等待';
    }
  }

  String _getButtonText() {
    switch (status) {
      case PeopleIdentityStatus.doing:
        return '我知道了';
      case PeopleIdentityStatus.success:
        return '发起实名认证';
      case PeopleIdentityStatus.failed:
        return '去修改';
      default:
        return '';
    }
  }
}

enum PeopleIdentityStatus { doing, success, failed }
