import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_center/widget/result_layout.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:flutter/material.dart';

class IdentityOutTime extends StatefulWidget {
  const IdentityOutTime({super.key});

  @override
  State<IdentityOutTime> createState() => _IdentityOutTimeState();
}

class _IdentityOutTimeState extends State<IdentityOutTime> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: MyAppBar(
        '实名认证',
      ),
      body: SingleChildScrollView(
        child: Column(
          children: [
            SizedBox(
              height: 10,
            ),
            ResultLayout(
              title: '认证过期',
              icon: 'circle_failed',
            ),
            SizedBox(
              height: 10,
            ),
          ],
        ),
      ),
      bottomNavigationBar: SafeArea(
        child: ButtonPublicRadius(
          text: '再次认证',
          onPress: () {
            Get.offNamed(RouteConfig.identityUserIdCardPage);
          },
          margin: EdgeInsets.only(bottom: 20, left: 20, right: 20),
        ),
      ),
    );
  }
}
