import 'package:account_center/account_center.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/account_center/widget/result_layout.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:flutter/material.dart';

class AccountCancellationResult extends StatelessWidget {
  final dynamic data;

  const AccountCancellationResult(this.data, {super.key});

  @override
  Widget build(BuildContext context) {
    bool isSuccess = data['deleteFlag'] == true;
    return Scaffold(
      appBar: MyAppBar('账户注销'),
      body: SingleChildScrollView(
        child: Column(
          children: [
            SizedBox(
              height: 10,
            ),
            ResultLayout(
              title: isSuccess ? '注销成功' : '注销失败',
              icon: isSuccess ? 'circle_success' : 'circle_failed',
              buttonText: isSuccess ? '完成' : null,
              onTap: isSuccess
                  ? () => Get.offAllNamed(AccountCenter.loginRouter)
                  : null,
            ),
            Visibility(
              visible: !isSuccess,
              child: Container(
                padding: EdgeInsets.symmetric(horizontal: 10),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    SizedBox(
                      height: 17,
                    ),
                    Container(
                      margin: EdgeInsets.only(left: 5),
                      child: Text(
                        '由于以下原因，账号无法注销',
                        style: TextStyle(
                          color: Color(0xFFA4A8B1),
                          fontSize: 15,
                        ),
                      ),
                    ),
                    SizedBox(
                      height: 10,
                    ),
                    Container(
                      height: 60,
                      width: double.infinity,
                      decoration: BoxDecoration(
                        color: Colors.white,
                        borderRadius: BorderRadius.circular(8),
                      ),
                      alignment: Alignment.centerLeft,
                      padding: EdgeInsets.only(left: 20),
                      child: Text(
                        '账号未解除公司员工身份',
                        style:
                            TextStyle(color: Color(0xFF222222), fontSize: 15),
                      ),
                    ),
                    SizedBox(
                      height: 20,
                    ),
                    Text(
                      '您目前在下列公司中就职，请联系公司管理员协助您处理：',
                      style: TextStyle(
                        color: Color(0xFFA4A8B1),
                        fontSize: 15,
                      ),
                    ),
                    ...((data['companyList'] ?? []) as List<dynamic>)
                        .map<Widget>((e) {
                      return Container(
                        margin: EdgeInsets.only(top: 10),
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(8),
                        ),
                        padding:
                            EdgeInsets.symmetric(horizontal: 15, vertical: 8),
                        child: Row(
                          children: [
                            ImageLoad.companyLogo(
                              e['companyLogo'],
                              width: 44,
                              height: 44,
                            ),
                            SizedBox(
                              width: 10,
                            ),
                            Expanded(
                              child: Text(
                                e['companyName'],
                                style: TextStyle(
                                    color: Color(0xFF222222), fontSize: 15),
                                overflow: TextOverflow.ellipsis,
                              ),
                            )
                          ],
                        ),
                      );
                    })
                  ],
                ),
              ),
            ),
          ],
        ),
      ),
      bottomNavigationBar: Visibility(
        visible: !isSuccess,
        child: ButtonPublicRadius(
          text: '我知道了',
          onPress: () {
            Get.back();
          },
          margin: EdgeInsets.only(left: 20, right: 20, bottom: 20),
        ),
      ),
    );
  }
}
