import 'dart:async';

import 'package:account_center/account_center.dart';
import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/page/account_center/account_info/account_info_logic.dart';
import 'package:account_center/page/account_center/account_info/identification_util.dart';
import 'package:account_center/page/account_center/widget/result_layout.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/confirm_dialog.dart';
import 'package:account_center/widget/one_button_dialog.dart';
import 'package:flutter/material.dart';

class IdentityDoing extends StatefulWidget {
  const IdentityDoing({super.key});

  @override
  State<IdentityDoing> createState() => _IdentityDoingState();
}

class _IdentityDoingState extends State<IdentityDoing> {
  dynamic _result;
  @override
  void initState() {
    _requestResult().then((value) {
      setState(() {
        _result = value;
      });
    });
    super.initState();
  }

  Future<dynamic> _requestResult() {
    var completer = Completer<dynamic>();
    fetch(Method.get,
        url: '/msl-user/user/idCard/getUserAuditResult',
        queryParameters: {'userNo': getUserNo()}, onSuccess: (response) {
      completer.complete(response);
    }, onError: (e, c) {
      completer.complete(null);
    });
    return completer.future;
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.white,
      appBar: MyAppBar(
        '实名认证',
      ),
      body: Column(
        children: [
          ResultLayout(
            title: '人工审核中',
            secondTitle: '信息审核中，大概需要1-3个工作日，请耐心等待',
            icon: 'circle_success',
            buttonText: '重新上传',
            onTap: _reIdentity,
          ),
          Container(
            margin: EdgeInsets.symmetric(horizontal: 20, vertical: 10),
            padding: EdgeInsets.only(left: 20),
            decoration: BoxDecoration(
              color: Color(0xFFF3F6FA),
              borderRadius: BorderRadius.circular(4),
            ),
            child: Column(
              children: [
                _content(
                  title: '姓名',
                  content: _result?['name'] ?? '',
                ),
                _content(
                  title: '身份证',
                  content: _result?['idCardNo'] ?? '',
                ),
                _content(
                  title: '有效期',
                  content: _result?['longTermFlag'] == 1
                      ? '长期有效'
                      : (_result?['cardBeginDate'] ?? '') +
                          ' 到 ' +
                          (_result?['cardEndDate'] ?? ''),
                ),
              ],
            ),
          ),
        ],
      ),
    );
  }

  Widget _content({required String title, required String content}) {
    return SizedBox(
      width: double.infinity,
      height: 44,
      child: Row(
        children: [
          SizedBox(
            width: 85,
            child: Text(
              title,
              style: TextStyle(
                fontSize: 14,
                color: Color(0xff171A1D),
              ),
            ),
          ),
          Text(
            content,
            style: TextStyle(
              fontSize: 14,
              color: Color(0xff171A1D),
            ),
          )
        ],
      ),
    );
  }

  void _reIdentity() async {
    LoadingUtils.showLoading();
    var result = await _requestResult();
    LoadingUtils.dismiss();
    var status = result?['auditStatus'];
    if (status == 1) {
      //审核成功
      ConfirmDialog(
        content: '您提交的信息已完成审核，并审核通过；',
        confirmButtonText: '前往人脸验证',
        cancelButtonText: '重新上传',
        cancel: () {
          Get.back();
          Get.offNamed(RouteConfig.identityUserIdCardPage);
        },
        confirm: () {
          IdentificationUtil.startFaceVerify().then((value) {
            if (value != null) {
              Get.back(result: value);
              findOtherLogic<AccountInfoLogic>()?.checkResult(value);
            }
          });
        },
      ).show();
    } else if (status == 2) {
      // 审核驳回
      OneButtonDialog(
        content: '很抱歉，您提交的人工审核信息未通过\n\n失败原因：${result?['auditRemark'] ?? '暂无'}',
        confirmButtonText: '重新上传',
        confirm: () {
          Get.offNamed(RouteConfig.identityUserIdCardPage);
        },
      ).show();
    } else {
      Get.offNamed(RouteConfig.identityUserIdCardPage);
    }
  }
}
