import 'package:account_center/api/base_model.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/company_extension.dart';
import 'package:account_center/page/account_company/stamp_use_history/widget/history_screen.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';
import 'package:get/get.dart';

class SignHistoryLogic extends GetxController {
  var listController = MyListController();

  dynamic userInfo;
  @override
  void onInit() {
    userInfo = Get.arguments;
    super.onInit();
  }

  void requestData(
    int page,
    int pageSize,
    SuccessCallback success,
    ErrorCallback error,
  ) {
    fetch(
      Method.post,
      url: '/msl-document/contractEvidence/pageEvidence',
      params: {
        'page': page,
        'pageSize': pageSize,
        'relationNoLike': code,
        'startTime': startTime,
        'endTime': endTime,
        'signatureId': userInfo['sealId'],
        'sealType': 1
      },
      onSuccess: (response) {
        success.call(response?['records']);
      },
    );
  }

  String? code;
  String? startTime = DateTime.now().add(Duration(days: -30)).toYMDStart;
  String? endTime = DateTime.now().toYMDEnd;

  void showFilter() {
    Get.bottomSheet(
      HistoryScreen(
          startTime: startTime,
          endTime: endTime,
          serviceCode: code,
          showName: false,
          stampScreenBlock: _stampScreenBlock),
      isScrollControlled: true,
    );
  }

  void _stampScreenBlock(
      stamp, String? code, String? startTime, String? endTime) {
    this.startTime = startTime;
    this.endTime = endTime;
    this.code = code;
    listController.callRefresh();
  }
}
