import 'package:account_center/account_center.dart';
import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/page/account_center/account_center_logic.dart';
import 'package:account_center/page/account_center/account_info/account_info_logic.dart';
import 'package:account_center/page/account_center/change_phone_success.dart';
import 'package:flutter/src/widgets/editable_text.dart';
import 'package:flutter/src/widgets/focus_manager.dart';

class ChangePhoneLogic extends GetxController {
  TextEditingController phoneController = TextEditingController();
  FocusNode phoneNode = FocusNode();

  TextEditingController vCodeController = TextEditingController();
  FocusNode codeNode = FocusNode();

  var codeErr = false;

  var codeErrText = '';

  dynamic oldPhone;

  @override
  void onInit() {
    oldPhone = Get.arguments?['phone'] ?? '';
    super.onInit();
  }

  void changePhone() {
    var phone = phoneController.text;
    if (phone == oldPhone) {
      ToastUtil.showToast("新手机号不可与当前手机号相同");
      return;
    }
    if (phone.length != 11) {
      ToastUtil.showToast("请输入正确的手机号");
      return;
    }
    var code = vCodeController.text;
    if (code.length != 6) {
      ToastUtil.showToast("请输入正确的验证码");
      return;
    }
    LoadingUtils.showLoading();
    fetch(Method.post, url: HttpApi.updateUserMobileCaptcha, params: {
      "captcha": vCodeController.text,
      "userMobile": phoneController.text,
      "userNo": getUserNo(),
    }, onSuccess: (data) {
      ToastUtil.showToast('修改成功');
      LoadingUtils.dismiss();
      var accountCenterLogic = findOtherLogic<AccountInfoLogic>();
      accountCenterLogic?.onReady();
      findOtherLogic<AccountCenterLogic>()?.onReady();
      Get.off(ChangePhoneSuccess(accountCenterLogic?.isRealNamed() ?? false));
    }, onError: (code, msg) {
      LoadingUtils.dismiss();
    });
  }
}
