enum UserAccountEnv {
  prod,
  pre,
  test,
  dev,
}

const dev = "https://gateway.devclx.cn";
const test = "https://gateway.testclx.cn";
const pre = "https://gateway.preclx.cn";
const prod = "https://gateway.91msl.com";

UserAccountEnv? env;

String get apiHost {
  switch (env) {
    case UserAccountEnv.dev: //生产环境
      return dev;
    case UserAccountEnv.test: //预发布环境
      return test;
    case UserAccountEnv.pre: //测试环境
      return pre;
    case UserAccountEnv.prod: //测试环境
      return prod;
    default: //默认是测试环境
      return test;
  }
}

String get ossDomain {
  switch (env) {
    case UserAccountEnv.dev:
    case UserAccountEnv.test: //预发布环境
    case UserAccountEnv.pre: //测试环境
      return _devOssDomain;
    case UserAccountEnv.prod: //测试环境
      return _prodOssDomain;
    default: //默认是测试环境
      return _devOssDomain;
  }
}

String get eSignRedirectUrl {
  switch (env) {
    case UserAccountEnv.dev:
    case UserAccountEnv.test:
    case UserAccountEnv.pre:
      return 'http://account.testclx.cn/face-result';
    case UserAccountEnv.prod:
      return 'https://account.91msl.com/face-result';
    default: //默认是测试环境
      return 'http://account.testclx.cn/face-result';
  }
}

const _devOssDomain = 'https://clx-dev.oss-cn-beijing.aliyuncs.com';

const _prodOssDomain = 'https://clx-prod.oss-cn-beijing.aliyuncs.com';
