import 'package:flutter/material.dart';

class UnorderedList extends StatelessWidget {
  /// string 或者 Widget
  final List<dynamic> items;
  final TextStyle textStyle;
  final double capSpace;
  const UnorderedList(
      {super.key,
      required this.items,
      this.textStyle = const TextStyle(
          fontSize: 14.0, color: Color(0xFF344254), height: 1.45),
      this.capSpace = 8.0});

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: items.map((item) {
        return Row(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Container(
              margin: EdgeInsets.only(top: 4.0),
              width: capSpace, // 调整缩进距离
              child: Text(
                '•', // 使用圆点符号作为列表标记
                style: textStyle.copyWith(height: 1),
              ),
            ),
            const SizedBox(width: 6.0), // 调整标记与文本之间的距离
            Expanded(
              child: item is String
                  ? Text(
                      item,
                      style: textStyle,
                    )
                  : item,
            ),
          ],
        );
      }).toList(),
    );
  }
}
