import 'package:flutter/material.dart';

/// 表单行
class FormRow extends StatelessWidget {
  final String title;
  final Widget child;

  /// 上下间距
  final double vCap;

  /// 是否显示必填*
  final bool isRequired;

  final CrossAxisAlignment crossAxisAlignment;

  final bool enabled;

  const FormRow({
    required this.title,
    required this.child,
    this.isRequired = false,
    this.vCap = 14,
    this.crossAxisAlignment = CrossAxisAlignment.center,
    this.enabled = true,
    Key? key,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      width: double.infinity,
      color: Colors.white,
      padding: EdgeInsets.symmetric(horizontal: 20),
      child: Column(
        mainAxisSize: MainAxisSize.min,
        children: [
          SizedBox(
            height: vCap,
          ),
          Row(
            crossAxisAlignment: crossAxisAlignment,
            children: [
              Text(
                '*',
                style: TextStyle(
                    color: isRequired ? Colors.red : Colors.transparent),
              ),
              SizedBox(
                width: 85,
                child: Text(
                  title,
                  maxLines: null,
                  style: TextStyle(
                    fontSize: 16,
                    color: enabled ? Color(0xff171A1D) : Color(0xff171A1D),
                  ),
                ),
              ),
              Expanded(
                child: child,
              )
            ],
          ),
          SizedBox(
            height: vCap,
          ),
          const Divider(
            height: 1,
          ),
        ],
      ),
    );
  }
}
