import 'package:account_center/common/utils/throttle_util.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

class ButtonPublicRadiusOutlineTheme extends StatelessWidget {
  final String text;
  final Function? onPress;
  final double width;
  final double height;
  final EdgeInsetsGeometry margin;
  final double radius;

  const ButtonPublicRadiusOutlineTheme(
      {Key? key,
      required this.text,
      required this.onPress,
      this.width = double.infinity,
      this.height = 45.0,
      this.margin = const EdgeInsets.symmetric(horizontal: 15),
      this.radius = 8})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return InkWell(
      onTap: ThrottleUtil().throttle(onPress),
      child: Container(
        height: height,
        width: width,
        margin: margin,
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(radius),
          border: Border.all(color: StyleParams.themeColor),
          color: Colors.white,
        ),
        alignment: Alignment.center,
        child: Text(
          text,
          style: TextStyle(
            fontSize: 15,
            color: StyleParams.themeColor,
            fontWeight: FontWeight.w600,
          ),
        ),
      ),
    );
  }
}
