import 'package:flutter/material.dart';

class BottomLayout extends StatelessWidget {
  final Widget child;
  const BottomLayout({Key? key, required this.child}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    var bottomPadding = MediaQuery.of(context).padding.bottom - 8;
    if (bottomPadding < 0) bottomPadding = 0;
    return Container(
      padding: EdgeInsets.only(bottom: bottomPadding),
      color: Colors.white,
      child: child,
    );
  }
}
