import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

class BottomLayoutButton extends StatelessWidget {
  final String name;
  final bool isDelete;
  final Function()? onPress;
  const BottomLayoutButton({
    Key? key,
    required this.name,
    this.isDelete = false,
    this.onPress,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    double bottomPadding = MediaQuery.of(context).padding.bottom - 8;
    if (bottomPadding < 0) bottomPadding = 0.0;
    return GestureTapWidget(
      onTap: onPress,
      child: Container(
        color: Colors.white,
        width: double.infinity,
        alignment: Alignment.center,
        padding: EdgeInsets.only(
          top: 20,
          bottom: (20.0 + bottomPadding),
        ),
        child: Text(
          name,
          style: isDelete
              ? RTextStyle.deleteButtonStyle
              : TextStyle(
                  fontSize: 16,
                  color: StyleParams.themeColor,
                ),
        ),
      ),
    );
  }
}
