import 'package:account_center/account_center.dart';
import 'package:account_center/common/res/colors.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

class BottomButtons extends StatelessWidget {
  final List<ButtonItem> items;
  const BottomButtons({Key? key, required this.items}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    var bottomPadding = MediaQuery.of(context).padding.bottom;
    return Visibility(
      visible: items.isNotEmpty,
      child: Container(
        color: Colors.white,
        padding: EdgeInsets.only(bottom: bottomPadding),
        width: double.infinity,
        child: SizedBox(
          height: 50,
          child: Row(
            children: _getButtons(context),
          ),
        ),
      ),
    );
  }

  List<Widget> _getButtons(BuildContext context) {
    List<Widget> result = [];
    List<ButtonItem> bottomShow = [];
    if (items.length > 3) {
      bottomShow.addAll(items.sublist(0, 2));
      bottomShow.add(
        ButtonItem(
            title: '更多',
            onClick: () {
              _more(context);
            }),
      );
    } else {
      bottomShow.addAll(items);
    }

    for (int i = 0; i < bottomShow.length; i++) {
      ButtonItem item = bottomShow[i];
      if (i != 0) {
        result.add(_bottomBarSplitLine());
      }
      result.add(
        textButton(
          item.title ?? '',
          item.onClick,
          isDelete: item.isDelete,
        ),
      );
    }
    return result;
  }

  Widget textButton(String title, void Function()? onTab,
      {bool isDelete = false}) {
    return Expanded(
      flex: 1,
      child: Center(
        child: TextButton(
          style: ButtonStyle(
              foregroundColor: isDelete
                  ? MaterialStateProperty.all(RColors.deleteColor)
                  : MaterialStateProperty.all(StyleParams.themeColor)),
          onPressed: onTab,
          child: Text(title),
        ),
      ),
    );
  }

  Container _bottomBarSplitLine() {
    return Container(
      color: Color(0xffE1E1E2),
      width: 0.5,
      height: 24,
    );
  }

  void _more(BuildContext context) {
    Get.bottomSheet(
      Container(
        decoration: const BoxDecoration(
            color: Colors.white,
            borderRadius: BorderRadius.vertical(top: Radius.circular(16))),
        padding: EdgeInsets.only(bottom: MediaQuery.of(context).padding.bottom),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: _getMoreWidget(),
        ),
      ),
      enableDrag: false,
      isScrollControlled: true,
    );
  }

  List<Widget> _getMoreWidget() {
    List<Widget> result = [];
    for (int i = 2; i < items.length; i++) {
      var e = items[i];
      result.add(mackButton(e.title ?? '', () {
        Get.back();
        e.onClick?.call();
      }));
      if (i != 2) {
        Container(
          height: 1,
          width: double.infinity,
          color: Color(0xffF3F5F8),
        );
      }
    }
    result.add(Container(
      height: 8,
      width: double.infinity,
      color: Color(0xffF3F5F8),
    ));
    result.add(mackButton('取消', () {
      Get.back();
    }));
    return result;
  }

  Widget mackButton(String title, VoidCallback callback,
      {BoxDecoration? decoration}) {
    return SizedBox(
      height: 50,
      width: double.infinity,
      child: TextButton(
        onPressed: callback,
        child: Text(
          title,
          style: TextStyle(
            color: Color(0xff344254),
            fontWeight: FontWeight.w500,
            fontSize: 16,
          ),
        ),
      ),
    );
  }
}

class ButtonItem {
  ButtonItem({this.title, this.onClick, this.isDelete = false});
  String? title;
  void Function()? onClick;
  bool isDelete = false;
}
