import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:flutter/material.dart';

class UserMessageShow extends StatelessWidget {
  final List<dynamic> listData;
  final void Function()? onCheck;
  final String title;
  final String nameKey;
  final double titleFontSize;
  const UserMessageShow(
    this.listData, {
    Key? key,
    required this.title,
    this.onCheck,
    this.nameKey = 'name',
    this.titleFontSize = 15,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GestureTapWidget(
      onTap: onCheck,
      child: Container(
        decoration: BoxDecoration(
          color: const Color(0xffFFFFFF),
          borderRadius: BorderRadius.circular(8),
        ),
        padding: const EdgeInsets.symmetric(horizontal: 8),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            SizedBox(height: 15),
            _titleMessage(),
            SizedBox(height: 10),
            Wrap(
              spacing: 10,
              runSpacing: 10,
              children: [
                ...listData.map((e) {
                  return Container(
                    padding:
                        const EdgeInsets.symmetric(horizontal: 10, vertical: 7),
                    decoration: BoxDecoration(
                      color: const Color(0xFFF5F6FA),
                      borderRadius: BorderRadius.circular(4),
                    ),
                    child: Text(
                      e[nameKey],
                      style: TextStyle(
                          color: Color(0xFF76777C),
                          fontSize: 12,
                          fontWeight: FontWeight.w400,
                          height: 1.2),
                    ),
                  );
                }).toList(),
              ],
            ),
            SizedBox(height: 10),
          ],
        ),
      ),
    );
  }

  Row _titleMessage() {
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceBetween,
      children: [
        Text(
          title,
          style: TextStyle(
            color: Color(0xff171A1D),
            fontSize: titleFontSize,
            fontWeight: FontWeight.w500,
          ),
        ),
        Visibility(
          visible: onCheck != null,
          child: Icon(
            Icons.arrow_forward_ios,
            size: 16,
            color: Color(0xffA4A8B1),
          ),
        ),
      ],
    );
  }
}
