import 'package:account_center/common/res/colors.dart';
import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_widget.dart';
import 'package:account_center/style/widget/edit_app_bar.dart';
import 'package:account_center/widget/search_bar.dart' as search_bar;
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

import 'staff_select_logic.dart';

class StaffSelectPage extends StatelessWidget {
  final logic = Get.find<StaffSelectLogic>();
  final state = Get.find<StaffSelectLogic>().state;

  StaffSelectPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: EditAppBar(
        title: '选择人员',
        confirm: () {
          logic.completed();
        },
      ),
      body: _bodyContent(),
    );
  }

  Widget _bodyContent() {
    return Column(
      children: [
        search_bar.MySearchBar(
          backgroundColor: Colors.white,
          hintText: '输入人员名称、手机号',
          onSearchClick: logic.search,
          onChange: logic.searchKeyChange,
        ),
        vGap10,
        Expanded(
          child: MyListViewPublic(
            firstRefresh: true,
            pageSize: 20,
            controller: state.userListController,
            itemBuilder: (context, index, data) {
              return GetBuilder<StaffSelectLogic>(builder: (logic) {
                return mackItem(data);
              });
            },
            requestData: (int page, int pageSize, success, error) {
              logic.getItemList(page, pageSize, success, error);
            },
          ),
        ),
      ],
    );
  }

  Widget mackItem(staff) {
    bool isChecked = logic.isChecked(staff);
    bool isForbid = logic.isForbid(staff);
    return GestureTapWidget(
      onTap: () {
        logic.itemTap(staff, !isChecked, isForbid);
      },
      child: Column(
        children: [
          Container(
            color: Colors.white,
            padding: EdgeInsets.symmetric(horizontal: 15),
            child: Column(
              children: [
                vGap15,
                Row(
                  children: [
                    SizedBox(
                      height: 42,
                      width: 42,
                      child: ImageLoad.user(staff['headImg'],
                          fit: BoxFit.cover, type: ImageTransformerType.circle),
                    ),
                    hGap15,
                    Expanded(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(
                            staff['userName'] ?? '',
                            style: RTextStyle.mainContentStyle,
                          ),
                          vGap4,
                          Text(
                            staff['userMobile'] ?? '',
                            style: TextStyle(
                              color: RColors.hintColor,
                              fontSize: 12,
                            ),
                          ),
                        ],
                      ),
                    ),
                    StyleWidget.checkBox(
                      isChecked || isForbid,
                      (value) {
                        logic.itemTap(staff, value == true, isForbid);
                      },
                      forbid: isForbid || logic.maxPositionNum(staff),
                    ),
                  ],
                ),
                vGap15,
                Divider(
                  height: 0.5,
                  color: Color(0xffe1e1e2),
                )
              ],
            ),
          ),
        ],
      ),
    );
  }
}
