import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/tree_node/tree_list.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'position_tree_logic.dart';

class PositionTreePage extends StatelessWidget {
  final logic = Get.find<PositionTreeLogic>();
  final state = Get.find<PositionTreeLogic>().state;

  PositionTreePage({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<PositionTreeLogic>(builder: (s) {
      return MyScaffold(
        appBar: MyAppBar('职位详情'),
        body: Column(
          children: [
            Expanded(child: TreeListWidget(state.nodes)),
            Container(
              color: Colors.white,
              alignment: Alignment.center,
              padding: EdgeInsets.symmetric(vertical: 5),
              child: Visibility(
                visible: hasMenuPermission('btn_remove_member_position'),
                child: TextButton(
                  onPressed: logic.deletePosition,
                  child: Text(
                    '移除此职位',
                    style: RTextStyle.deleteButtonStyle,
                  ),
                ),
              ),
            )
          ],
        ),
      );
    });
  }
}
