import 'package:flutter/cupertino.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class CodeVerifyButton extends StatefulWidget {
  final String text;
  final VoidCallback callBack;
  const CodeVerifyButton(this.text, this.callBack, {Key? key})
      : super(key: key);

  @override
  State<CodeVerifyButton> createState() => _CodeVerifyButtonState();
}

class _CodeVerifyButtonState extends State<CodeVerifyButton> {
  bool enable = true;
  var time = '';
  @override
  Widget build(BuildContext context) {
    return GFButton(
      text: enable ? widget.text : time,
      onPressed: enable
          ? () {
              widget.callBack();
              startCountDown();
            }
          : null,
    );
  }

  void startCountDown() {
    enable = false;
    TimerUtil(mTotalTime: 3 * 1000)
      ..setOnTimerTickCallback((millisUntilFinished) {
        setState(() {
          time = "${millisUntilFinished / 1000}(s)";
          if (millisUntilFinished == 0) {
            enable = true;
          }
        });
      })
      ..startCountDown();
  }
}
