import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

class LoginInput extends StatelessWidget {
  final String title;
  final ValueChanged<String> valueChange;
  const LoginInput(this.title, this.valueChange, {Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Row(
      children: [
        Text(title),
        Expanded(
          child: Container(
            child: TextField(
              onChanged: valueChange,
              cursorColor: StyleParams.themeColor,
            ),
          ),
        )
      ],
    );
  }
}
