import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/widget/bottom_safe_layout.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/search_bar.dart' as search_bar;
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

import 'position_manage_logic.dart';

class PositionManagePage extends StatelessWidget {
  final logic = Get.find<PositionManageLogic>();

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: MyAppBar(
        '职位管理',
      ),
      resizeToAvoidBottomInset: false,
      body: GetBuilder<PositionManageLogic>(builder: (s) {
        return Column(
          children: [
            search_bar.MySearchBar(
              backgroundColor: Colors.white,
              hintText: '请输入职位名称',
              onSearchClick: logic.search,
              onChange: logic.searchKeyChange,
            ),
            vGap10,
            Expanded(
              child: MyListViewPublic(
                firstRefresh: true,
                pageSize: 20,
                controller: logic.positionListController,
                itemBuilder: (context, index, data) {
                  return mackItem(data);
                },
                requestData: (int page, int pageSize, success, error) {
                  logic.requestPositionList(page, pageSize, success, error);
                },
                padding: EdgeInsets.zero,
              ),
            ),
          ],
        );
      }),
      bottomNavigationBar: Visibility(
        visible: true,
        child: BottomLayout(
          child: ButtonPublicRadius(
            onPress: () {
              logic.newPosition();
            },
            text: '新建职位',
            margin: EdgeInsets.symmetric(horizontal: 15, vertical: 8),
          ),
        ),
      ),
    );
  }

  Widget mackItem(element) {
    return GestureTapWidget(
      onTap: () => logic.editPosition(element),
      child: Container(
        margin: EdgeInsets.only(bottom: 10),
        padding: EdgeInsets.all(20),
        decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.circular(8),
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Row(children: [
              ImageLoad.svgTagIcon('zhiwei'),
              hGap15,
              Text(
                element['positionName'] +
                    "（" +
                    (element['userNum']?.toString() ?? '0') +
                    '）',
                style: RTextStyle.mainContentStyle,
              ),
            ]),
            Icon(
              size: 20,
              Icons.arrow_forward_ios,
              color: Colors.grey[400],
            )
          ],
        ),
      ),
    );
  }
}
