import 'package:account_center/api/base_model.dart';
import 'package:account_center/routes/route_config.dart';
import 'package:account_center/widget/confirm_dialog.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class EditOrNewPositionLogic extends GetxController {
  var personList = <dynamic>[];

  var controller = TextEditingController();

  var focusNode = FocusNode();

  ///去重复
  List<String> userNos = [];

  var title = '';

  /// true:编辑 false:新建
  bool isEdit = false;

  var showErr = false;

  dynamic data;
  @override
  void onInit() {
    data = Get.arguments;
    isEdit = data != null;
    title = isEdit ? '职位设置' : '新建职位';
    if (isEdit) {
      controller.text = data['positionName'];
      _requestPersonList();
    }
    super.onInit();
  }

  void goToPersonListPage() {
    focusNode.unfocus();
    Get.toNamed(
      RouteConfig.staffListSelectPage,
      arguments: {'forbidNo': userNos},
    )?.then((data) {
      if (data != null) {
        for (var e in data) {
          if (e['userNo']?.toString().isNotEmpty == true) {
            userNos.add(e['userNo']?.toString() ?? '');
            personList.add(e);
          }
        }
        update();
      }
    });
  }

  void deletePerson(item) {
    userNos.remove(item['userNo']);
    personList.remove(item);
    update();
  }

  void confirm() {
    if (controller.text.isEmpty) {
      showErr = true;
      update();
      return;
    }
    LoadingUtils.showLoading(text: '');
    if (isEdit) {
      fetch(Method.post, url: HttpApi.updatePositionAndUser, params: {
        'positionNo': data?['positionNo'],
        'positionName': controller.text,
        'userNos': userNos,
      }, onSuccess: (data) {
        Get.back(result: {});
        LoadingUtils.dismiss();
        ToastUtil.showToast('修改成功');
      }, onError: (code, msg) {
        LoadingUtils.dismiss();
      });
    } else {
      fetch(Method.post, url: HttpApi.newPosition_1, params: {
        'positionName': controller.text,
        'userNos': userNos,
      }, onSuccess: (data) {
        Get.back(result: {});
        LoadingUtils.dismiss();
        ToastUtil.showToast('创建成功');
      }, onError: (code, msg) {
        LoadingUtils.dismiss();
      });
    }
  }

  void _requestPersonList() {
    fetch(Method.post, url: HttpApi.pagePositionUsers, params: {
      'positionNo': data?['positionNo'],
      'page': 1,
      'pageSize': 1000,
    }, onSuccess: (data) {
      personList = data['records'] ?? [];
      userNos = personList.map((e) => e['userNo']?.toString() ?? '').toList();
      update();
    }, onError: (code, msg) {
      ToastUtil.showToast(msg);
    });
  }

  void deletePosition() {
    ConfirmDialog(
      confirmButtonText: '删除职位',
      content: '确定删除该职位吗？',
      confirm: () {
        LoadingUtils.showLoading(text: '');
        fetch(Method.delete, url: HttpApi.deletePosition, queryParameters: {
          'positionNo': data?['positionNo'],
        }, onSuccess: (data) {
          Get.back(result: 'delete');
          ToastUtil.showToast('删除成功');
          LoadingUtils.dismiss();
        }, onError: (code, msg) {
          LoadingUtils.dismiss();
        });
      },
    ).show();
  }
}
