import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/account_company/company_home/company_manage_logic.dart';
import 'package:account_center/routes/route_config.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/button_public_radius_outline.dart';
import 'package:account_center/style/widget/button_public_radius_outline_theme.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/form/form_show.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class EnterpriseCreator extends StatefulWidget {
  const EnterpriseCreator({Key? key}) : super(key: key);

  @override
  State<EnterpriseCreator> createState() => _EnterpriseCreatorState();
}

class _EnterpriseCreatorState extends State<EnterpriseCreator> {
  var logic = findOtherLogic<CompanyManageLogic>();
  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: MyAppBar('企业创建人信息'),
        body: Container(
          width: double.infinity,
          margin: EdgeInsets.only(top: 10),
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: [
              FormShow(
                  title: '企业创建人',
                  content: logic?.companyDetail?['contactName']),
              FormShow(
                  title: '创建人手机号',
                  content: logic?.companyDetail?['contactMobile']),
            ],
          ),
        ),
        bottomNavigationBar: Visibility(
          visible: logic?.companyDetail?['contactNo'] == getUserNo(),
          child: SafeArea(
            child: ButtonPublicRadiusOutlineTheme(
              text: '转移企业',
              onPress: () {
                _showDialog();
              },
              margin: EdgeInsets.symmetric(horizontal: 25, vertical: 15),
            ),
          ),
        ));
  }

  void _showDialog() {
    Get.dialog(
      Dialog(
        child: Container(
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(10),
            color: Colors.white,
          ),
          padding: EdgeInsets.symmetric(horizontal: 35, vertical: 20),
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: [
              ImageLoad.loadAssertImage('circle_warning',
                  width: 60, height: 60),
              SizedBox(height: 20),
              Text(
                '请确认是否要移交企业管理权限，移交后您仍为当前企业的管理员。',
                style: TextStyle(
                  color: Color(0xFF909399),
                  fontSize: 15,
                ),
              ),
              SizedBox(height: 25),
              Row(
                children: [
                  Expanded(
                    child: ButtonPublicRadiusOutline(
                      text: '取消',
                      onPress: () {
                        Get.back();
                      },
                      margin: EdgeInsets.only(right: 0),
                    ),
                  ),
                  SizedBox(width: 15),
                  Expanded(
                    child: ButtonPublicRadius(
                      text: '确定转移',
                      onPress: () {
                        Get.back();
                        Get.toNamed(RouteConfig.staffListSelectPage,
                            arguments: {
                              'isSingle': true,
                              'forbidNo': [getUserNo()]
                            })?.then((value) {
                          if (value != null &&
                              value is List &&
                              value.isNotEmpty) {
                            logic?.transferCompany(value[0]).then((value) {
                              setState(() {});
                            });
                          }
                        });
                      },
                      margin: EdgeInsets.only(right: 0),
                    ),
                  ),
                ],
              )
            ],
          ),
        ),
      ),
    );
  }
}
