import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/res/colors.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/enterprise/role_management/role_details_page/role_details_logic.dart';
import 'package:account_center/style/widget/bottom_layout_button.dart';
import 'package:account_center/widget/asset_image_widget.dart';
import 'package:account_center/widget/no_data.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class RoleProductListPage extends StatelessWidget {
  final logic = Get.find<RoleDetailsLogic>();
  final state = Get.find<RoleDetailsLogic>().state;

  RoleProductListPage({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<RoleDetailsLogic>(builder: (logic) {
      return Column(
        children: [
          Expanded(
            child: _productListWidget(),
          ),
          Visibility(
            visible: hasMenuPermission('btn_role_add_product'),
            child: BottomLayoutButton(
              name: '新增产品',
              onPress: logic.goToAddProductPage,
            ),
          )
        ],
      );
    });
  }

  ///列表
  Widget _productListWidget() {
    return state.listPro.isEmpty
        ? NoData()
        : ListView.builder(
            itemBuilder: (context, index) {
              return _itemViewPro(state.listPro[index]);
            },
            itemCount: state.listPro.length,
          );
  }

  ///列表item
  Widget _itemViewPro(entity) {
    return InkWell(
      onTap: () {
        if (hasMenuPermission('btn_set_role_product') ||
            hasMenuPermission('btn_remove_role_product')) {
          logic.gotoProductPermissionPage(entity);
        }
      },
      child: Container(
        margin: EdgeInsets.symmetric(horizontal: 5),
        child: Card(
          elevation: 0,
          child: Container(
            padding: EdgeInsets.symmetric(horizontal: 15, vertical: 10),
            child: Row(
              children: [
                ImageLoad.productIcon(entity['productImgUrl'],
                    width: 50, height: 50, type: ImageTransformerType.rect),
                hGap15,
                Expanded(
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.center,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                        entity['productName'] ?? '',
                        style: TextStyle(
                            fontSize: 16, fontWeight: FontWeight.bold),
                      ),
                      vGap8,
                      Text(
                        entity['productDescribe'] ?? '',
                        style:
                            TextStyle(fontSize: 12, color: RColors.hintColor),
                      )
                    ],
                  ),
                ),
                Visibility(
                  visible: (hasMenuPermission('btn_set_role_product') ||
                      hasMenuPermission('btn_remove_role_product')),
                  child: TextButton.icon(
                    onPressed: () {
                      logic.gotoProductPermissionPage(entity);
                    },
                    icon: AssetImageWidget(
                      imgFileName: 'ic_permission',
                      height: 16,
                      width: 16,
                    ),
                    label: Text(
                      "设置",
                      style: TextStyle(
                        color: Color(0xFF165DFF),
                      ),
                    ),
                  ),
                ),
              ],
            ),
          ),
        ),
      ),
    );
  }
}
