import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/page/enterprise/role_management/role_details_page/role_details_logic.dart';
import 'package:account_center/style/widget/bottom_layout_button.dart';
import 'package:account_center/widget/no_data.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class DepartListPage extends StatelessWidget {
  final logic = Get.find<RoleDetailsLogic>();
  final state = Get.find<RoleDetailsLogic>().state;

  DepartListPage({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<RoleDetailsLogic>(builder: (logic) {
      return Column(
        children: [
          Expanded(
            child: _productListWidget(),
          ),
          Visibility(
            visible: hasMenuPermission('btn_role_add_department'),
            child: BottomLayoutButton(
              name: '添加部门',
              onPress: logic.addDepartment,
            ),
          )
        ],
      );
    });
  }

  ///列表
  Widget _productListWidget() {
    return logic.departmentList.isEmpty
        ? NoData()
        : ListView.builder(
            itemBuilder: (context, index) {
              return _makeDepartItem(logic.departmentList[index]);
            },
            itemCount: logic.departmentList.length,
          );
  }

  GestureTapWidget _makeDepartItem(element) {
    return GestureTapWidget(
      child: Container(
        padding: EdgeInsets.all(15),
        margin: EdgeInsets.only(left: 10, right: 10, top: 10),
        decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.circular(8),
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Row(
              children: [
                InkWell(
                  onTap: () {
                    logic.deleteDepart(element);
                  },
                  child: Visibility(
                    visible: hasMenuPermission('btn_update_role'),
                    child: Container(
                      margin: EdgeInsets.only(right: 5),
                      child: Icon(
                        Icons.remove_circle_outlined,
                        color: Colors.red,
                      ),
                    ),
                  ),
                ),
                ImageLoad.svgTagIcon('bumen'),
                hGap15,
                Text(
                  element['departmentName'],
                  style: RTextStyle.mainContentStyle,
                ),
              ],
            ),
          ],
        ),
      ),
    );
  }
}
