import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/asset_image_widget.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

import '../../../../common/res/colors.dart';
import 'product_list_logic.dart';

/// 选择产品 -产品列表
class ProductListPage extends StatelessWidget {
  final logic = Get.find<ProductListLogic>();
  final state = Get.find<ProductListLogic>().state;

  ProductListPage({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<ProductListLogic>(builder: (logic) {
      return MyScaffold(
        appBar: MyAppBar('选择产品'),
        body: _bodyContent(context),
      );
    });
  }

  Widget _bodyContent(context) {
    return MyListViewPublic(itemBuilder: (context, index, data) {
      return _itemViewPro(data);
    }, requestData: (page, pageSize, success, error) {
      logic.productListRequest(page, pageSize, success);
    });
  }

  ///产品列表条目
  Widget _itemViewPro(entity) {
    return InkWell(
      onTap: () {
        logic.goToProductDetailsPage(entity);
      },
      child: Container(
        margin: EdgeInsets.only(bottom: 1),
        padding: EdgeInsets.symmetric(horizontal: 20, vertical: 10),
        color: entity['isChecked'] ?? false ? Colors.grey[300] : Colors.white,
        child: Row(
          children: [
            ImageLoad.productIcon(entity['productImgUrl'],
                width: 60, height: 60, type: ImageTransformerType.rect),
            hGap15,
            Expanded(
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(
                    entity['productName'] ?? "",
                    style: TextStyle(fontSize: 16, fontWeight: FontWeight.bold),
                  ),
                  vGap8,
                  Text(
                    entity['productDescribe'] ?? "",
                    style: TextStyle(fontSize: 12, color: RColors.hintColor),
                  )
                ],
              ),
            ),
            TextButton.icon(
              icon: AssetImageWidget(
                imgFileName: 'ic_permission',
                height: 16,
                width: 16,
              ),
              label: Text(
                "权限",
                style: TextStyle(
                  color: Color(0xFF165DFF),
                ),
              ),
              onPressed: () {
                logic.goToProductDetailsPage(entity);
              },
            ),
          ],
        ),
      ),
    );
  }
}
