import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/res/colors.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/style/widget/bottom_layout_button.dart';
import 'package:account_center/style/widget/edit_app_bar.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/no_data.dart';
import 'package:account_center/widget/tree_node/tree_list.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'product_details_permission_logic.dart';

class ProductDetailsPermissionPage extends StatelessWidget {
  final logic = Get.find<ProductDetailsPermissionLogic>();
  final state = Get.find<ProductDetailsPermissionLogic>().state;

  ProductDetailsPermissionPage({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<ProductDetailsPermissionLogic>(builder: (s) {
      return MyScaffold(
        appBar: (state.onlyShow
            ? MyAppBar('公司产品')
            : EditAppBar(
                title: "选择产品",
                confirm: () {
                  logic.confirm();
                },
                cancel: () {
                  logic.back();
                },
                showConfirm: hasMenuPermission('btn_set_role_product'),
              )) as PreferredSizeWidget,
        body: _bodyContent(),
      );
    });
  }

  Widget _bodyContent() {
    return Column(
      children: [
        Container(
          margin: EdgeInsets.only(bottom: 1),
          padding: EdgeInsets.symmetric(horizontal: 20, vertical: 10),
          color: Colors.white,
          child: Row(
            children: [
              ImageLoad.productIcon(
                state.entity['productImgUrl'],
                width: 60,
                height: 60,
              ),
              hGap15,
              Expanded(
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.center,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(
                      state.entity['productName'] ?? '',
                      style:
                          TextStyle(fontSize: 16, fontWeight: FontWeight.bold),
                    ),
                    vGap8,
                    Text(
                      state.entity['productDescribe'] ?? '',
                      style: TextStyle(fontSize: 12, color: RColors.hintColor),
                    )
                  ],
                ),
              ),
            ],
          ),
        ),
        Expanded(
          child: state.listData.isNotEmpty
              ? TreeListWidget(
                  state.listData,
                  selectType: TreeSelectType.productMenu,
                )
              : NoData(
                  title: '暂无菜单',
                ),
        ),
        Visibility(
          visible: state.showDelete,
          child: BottomLayoutButton(
            isDelete: true,
            onPress: logic.deleteRole,
            name: '删除此产品',
          ),
        )
      ],
    );
  }
}
