import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/style/style_widget.dart';
import 'package:account_center/style/widget/edit_app_bar.dart';
import 'package:account_center/widget/form/form_input.dart';
import 'package:account_center/widget/form/form_row.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'position_setting_logic.dart';

class PositionSettingPage extends StatelessWidget {
  final logic = Get.find<PositionSettingLogic>();
  final state = Get.find<PositionSettingLogic>().state;

  PositionSettingPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
        appBar: EditAppBar(
          confirm: () {
            logic.updatePositionRequest();
          },
          title: '职位设置',
          showConfirm: hasMenuPermission(logic.fromMyDepartment
              ? 'btn_update_position_my'
              : 'btn_update_position'),
        ),
        body: _bodyContent());
  }

  Widget _bodyContent() {
    return GetBuilder<PositionSettingLogic>(builder: (logic) {
      return Column(
        children: [_inputName(), _isManager(), vGap20, _itemBottomBtn()],
      );
    });
  }

  ///职位名称
  Widget _inputName() {
    return FormInput(
        title: '职位名称',
        controller: state.controller,
        maxLength: 10,
        focusNode: state.focusNode);
  }

  ///角色策略
  Widget _isManager() {
    return FormRow(
      title: '设为管理员',
      child: Row(
        children: [
          _itemRadio(1, '是'),
          hGap40,
          _itemRadio(0, '否'),
        ],
      ),
    );
  }

  Widget _itemRadio(value, text) {
    return StyleWidget.itemRadio(value, state.radioIndex, text, (value) {
      logic.changeRadio(value);
    });
  }

  Widget _itemBottomBtn() {
    return InkWell(
      onTap: () {
        logic.deletePositionRequest();
      },
      child: Visibility(
        visible: hasMenuPermission(logic.fromMyDepartment
            ? 'btn_delete_position_my'
            : 'btn_delete_position_'),
        child: Container(
          alignment: Alignment.center,
          width: double.infinity,
          color: Colors.white,
          padding: EdgeInsets.symmetric(vertical: 15),
          child: Text(
            '删除此职位',
            style: RTextStyle.deleteButtonStyle,
          ),
        ),
      ),
    );
  }
}
