import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/res/colors.dart';
import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/enterprise/organization_structure/position_details_page/position_details_logic.dart';
import 'package:account_center/widget/confirm_dialog.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

class StaffListPage extends StatelessWidget {
  StaffListPage({Key? key}) : super(key: key);

  final logic = Get.find<PositionDetailsLogic>();
  final state = Get.find<PositionDetailsLogic>().state;

  @override
  Widget build(BuildContext context) {
    return MyListViewPublic(
        controller: state.memberListController,
        itemBuilder: (context, index, item) {
          return _mackItem(item);
        },
        pageSize: 500,
        requestData: (page, pageSize, success, error) {
          logic.usersListRequest(page, pageSize, success);
        });
  }

  Widget _mackItem(dynamic staff) {
    return GetBuilder<PositionDetailsLogic>(builder: (logic) {
      return Column(
        children: [
          Container(
            color: Colors.white,
            padding: EdgeInsets.symmetric(horizontal: 15),
            child: Column(
              children: [
                vGap15,
                Row(
                  children: [
                    ImageLoad.user(
                      staff?['headImg'],
                      fit: BoxFit.cover,
                      type: ImageTransformerType.circle,
                      width: 42,
                      height: 42,
                    ),
                    hGap15,
                    Expanded(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(
                            staff['userName'] ?? '',
                            style: RTextStyle.mainContentStyle,
                          ),
                          vGap4,
                          Text(
                            staff['userMobile'] ?? '',
                            style: TextStyle(
                              color: RColors.hintColor,
                              fontSize: 12,
                            ),
                          ),
                        ],
                      ),
                    ),
                    Visibility(
                      visible: logic.canShowBottom() &&
                          (logic.fromMyDepartment
                              ? hasMenuPermission(
                                  'btn_remove_position_member_my')
                              : hasMenuPermission(
                                  'btn_remove_position_member')),
                      child: TextButton(
                        onPressed: () {
                          ConfirmDialog(
                            content: '确定移除该人员？',
                            confirm: () {
                              logic.removeMember(staff['userNo']);
                            },
                          ).show();
                        },
                        child: Text(
                          '移除',
                          style: TextStyle(color: RColors.deleteColor),
                        ),
                      ),
                    ),
                  ],
                ),
                vGap15,
                Divider(
                  height: 0.5,
                  color: Color(0xffe1e1e2),
                )
              ],
            ),
          ),
        ],
      );
    });
  }
}
