import 'package:account_center/page/enterprise/organization_structure/new_position_page/tab_person_list_page/tab_person_list_view.dart';
import 'package:account_center/page/enterprise/organization_structure/new_position_page/tab_role_details_page/tab_role_details_view.dart';
import 'package:account_center/page/staff_manager/staff_detail/indicator_roundline.dart';
import 'package:account_center/style/style_widget.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/form/form_input.dart';
import 'package:account_center/widget/form/form_row.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'new_position_logic.dart';

final tabTextStyle = TextStyle(
  color: Color(0xff222222),
  fontSize: 15,
  fontWeight: FontWeight.w600,
);

///组织架构 新建职位
class NewPositionPage extends StatelessWidget {
  final logic = Get.find<NewPositionLogic>();
  final state = Get.find<NewPositionLogic>().state;

  NewPositionPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: MyAppBar('新建职位'),
      body: _bodyContent(),
    );
  }

  Widget _bodyContent() {
    return GetBuilder<NewPositionLogic>(builder: (logic) {
      return Container(
        padding: EdgeInsets.only(top: 10),
        child: Column(
          children: [
            _inputName(),
            _isManager(),
            vGap5,
            _tabBar(),
            vGap5,
            _tabBarView(),
            _itemBottomBtn()
          ],
        ),
      );
    });
  }

  ///职位名称
  Widget _inputName() {
    return FormInput(
      title: '职位名称',
      controller: state.controller,
      focusNode: state.focusNode,
      maxLength: 10,
    );
  }

  ///角色策略
  Widget _isManager() {
    return FormRow(
      title: '设为管理员',
      child: Row(
        children: [
          _itemRadio(1, '是'),
          SizedBox(
            width: 30,
          ),
          _itemRadio(0, '否'),
        ],
      ),
    );
  }

  Widget _itemRadio(value, text) {
    return StyleWidget.itemRadio(value, state.radioIndex, text, (value) {
      logic.changeRadio(value);
    }, forbid: !logic.canManager);
  }

  Expanded _tabBarView() {
    return Expanded(
      child: TabBarView(
        controller: logic.controller,
        children: [
          TabPersonListPage(),
          TabRoleDetailsPage(),
        ],
      ),
    );
  }

  Align _tabBar() {
    return Align(
      alignment: Alignment.topLeft,
      child: TabBar(
        padding: EdgeInsets.only(left: 15),
        isScrollable: true,
        indicatorSize: TabBarIndicatorSize.label,
        indicator: RoundLineIndicator(3.0),
        labelPadding: EdgeInsets.symmetric(vertical: 6, horizontal: 15),
        indicatorPadding: EdgeInsets.symmetric(horizontal: 20),
        tabs: [
          Text(
            '人员列表',
            style: tabTextStyle,
          ),
          Text(
            '角色详情',
            style: tabTextStyle,
          ),
        ],
        controller: logic.controller,
      ),
    );
  }

  Widget _itemBottomBtn() {
    return ButtonPublicRadius(
      margin: EdgeInsets.symmetric(
        horizontal: 15,
        vertical: 15,
      ),
      onPress: () {
        logic.textEmpty();
      },
      text: "确定",
    );
  }
}
