import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/style/style_widget.dart';
import 'package:account_center/style/widget/edit_app_bar.dart';
import 'package:account_center/widget/confirm_dialog.dart';
import 'package:account_center/widget/form/form_input.dart';
import 'package:account_center/widget/form/form_row.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'department_setting_logic.dart';

class DepartmentSettingPage extends StatelessWidget {
  final logic = Get.find<DepartmentSettingLogic>();
  final state = Get.find<DepartmentSettingLogic>().state;

  DepartmentSettingPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
        appBar: EditAppBar(
          confirm: () {
            logic.updatePositionRequest();
          },
          title: '部门设置',
          showConfirm: hasMenuPermission(logic.fromMyDepartment
              ? 'btn_update_department_my'
              : 'btn_update_department_'),
        ),
        body: _bodyContent());
  }

  Widget _bodyContent() {
    return GetBuilder<DepartmentSettingLogic>(builder: (logic) {
      return Column(
        children: [_inputName(), _isManager(), vGap20, _itemBottomBtn()],
      );
    });
  }

  ///职位名称
  Widget _inputName() {
    return FormInput(
        title: '部门名称',
        controller: state.controller,
        focusNode: state.focusNode);
  }

  ///角色策略
  Widget _isManager() {
    return FormRow(
      title: '主管管理',
      child: Row(
        children: [
          _itemRadio(1, '允许'),
          hGap40,
          _itemRadio(0, '不允许'),
        ],
      ),
    );
  }

  Widget _itemRadio(value, text) {
    return StyleWidget.itemRadio(
      value,
      state.radioIndex,
      text,
      (value) {
        logic.changeRadio(value);
      },
    );
  }

  Widget _itemBottomBtn() {
    return Visibility(
      visible: hasMenuPermission(logic.fromMyDepartment
          ? 'btn_delete_department_my'
          : 'btn_delete_department'),
      child: InkWell(
        onTap: () {
          ConfirmDialog(
            content: '确定删除此部门！',
            confirm: () {
              logic.deleteDepartmentRequest();
            },
          ).show();
        },
        child: Container(
          alignment: Alignment.center,
          width: double.infinity,
          color: Colors.white,
          padding: EdgeInsets.symmetric(vertical: 15),
          child: Text(
            '删除此部门',
            style: RTextStyle.deleteButtonStyle,
          ),
        ),
      ),
    );
  }
}
