import 'package:account_center/api/base_model.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'department_setting_state.dart';

class DepartmentSettingLogic extends GetxController {
  final DepartmentSettingState state = DepartmentSettingState();
  String departmentNo = '';
  String departmentPno = '0';
  bool fromMyDepartment = false;
  @override
  void onInit() {
    super.onInit();
    state.controller.text = Get.arguments['departmentName'] ?? '';
    departmentNo = Get.arguments['departmentNo'] ?? '';
    departmentPno = Get.arguments['departmentPno'] ?? '';
    state.radioIndex = Get.arguments['manageStatus'] ?? 0;
    fromMyDepartment = Get.arguments['isMyDepartment'] == true;
  }

  void changeRadio(value) {
    state.radioIndex = value;
    update();
  }

  ///更新部门设置
  void updatePositionRequest() {
    fetch(Method.post, url: HttpApi.updateDepartmentOrPosition,
        onSuccess: (data) {
      Get.back(result: {});
    }, params: {
      "manageStatus": state.radioIndex,
      "departmentDescribe": '',
      "departmentName": state.controller.text,
      "departmentNo": departmentNo,
      "departmentPno": departmentPno.toInt(),
    });
  }

  ///删除此部门
  void deleteDepartmentRequest() {
    fetch(Method.delete, url: HttpApi.deleteDepartmentOrPosition,
        onSuccess: (data) {
      Get.back(result: 'delete');
    }, queryParameters: {
      "departmentNo": departmentNo,
    });
  }
}
