import 'package:account_center/routes/route_config.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

class ChangeDepartmentLogic extends GetxController {
  var userListController = MyListController();
  List<dynamic> listSelected = [];
  List<dynamic> data = [];
  List<dynamic> showData = [];
  String searchKey = '';

  @override
  void onInit() {
    data = Get.arguments?['data'] ?? <dynamic>[];
    showData.addAll(data);
    super.onInit();
  }

  void next() {
    if (listSelected.isEmpty) {
      ToastUtil.showToast('请选择人员');
      return;
    }
    Get.toNamed(RouteConfig.setUserDepartmentPage,
        arguments: {'data': listSelected})?.then((value) {
      if (value != null) {
        Get.back(result: value);
      }
    });
  }

  search(key) {
    showData.clear();
    for (var e in data) {
      if (e['userName']?.contains(searchKey) == true) {
        showData.add(e);
      }
    }
    update();
  }

  void searchKeyChange(String? value) {
    searchKey = value ?? '';
    search(searchKey);
  }

  void itemTap(staff, bool bool) {
    staff['isChecked'] = bool;
    update();
    if (staff['isChecked'] == true) {
      listSelected.add(staff);
    } else {
      listSelected.remove(staff);
    }
  }
}
