import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/form/form_input.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'update_company_name_logic.dart';

class UpdateCompanyShortNameInfoPage extends StatelessWidget {
  final logic = Get.find<UpdateCompanyShortNameInfoLogic>();
  final state = Get.find<UpdateCompanyShortNameInfoLogic>().state;

  UpdateCompanyShortNameInfoPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: MyAppBar(state.title ?? '企业'),
      body: _bodyContent(),
    );
  }

  Widget _bodyContent() {
    return Column(
      children: [
        vGap15,
        FormInput(
            title: state.title ?? '',
            controller: state.controller,
            focusNode: state.node),
        vGap50,
        Container(
            margin: EdgeInsets.symmetric(vertical: 10),
            width: double.infinity,
            child: ButtonPublicRadius(
              onPress: () {
                logic.completed();
              },
              text: "确定",
            ))
      ],
    );
  }
}
