import 'package:account_center/page/enterprise/simple_page/cancellation_enterprise.dart';
import 'package:account_center/page/enterprise/simple_page/enterprise_creator.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/asset_image_widget.dart';
import 'package:account_center/widget/global_card_widget.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'new_enterprise_see_logic.dart';

class NewEnterpriseSeePage extends StatelessWidget {
  final logic = Get.find<NewEnterpriseSeeLogic>();
  final state = Get.find<NewEnterpriseSeeLogic>().state;

  NewEnterpriseSeePage({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.white,
      appBar: MyAppBar(
        '企业信息',
        actions: [
          GestureDetector(
            onTap: () {
              Get.to(CancellationEnterprise());
            },
            child: Container(
              padding: const EdgeInsets.only(right: 15),
              alignment: Alignment.centerRight,
              child: Text(
                '申请注销',
                style: TextStyle(fontSize: 15),
              ),
            ),
          )
        ],
      ),
      body: _bodyContent(context),
    );
  }

  Widget _bodyContent(context) {
    return GetBuilder<NewEnterpriseSeeLogic>(builder: (logic) {
      return Column(
        children: [
          Expanded(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                _itemView(logic.baseInfoTitle(), logic.baseInfoHint(), () {
                  logic.goToBasicPage();
                }, marginTop: 30),
                _itemView(logic.proxyPersonTitle(), logic.proxyPersonHint(),
                    () {
                  logic.goToProxyPersonPage();
                }),
                _itemView(logic.legalPersonTitle(), logic.legalPersonHint(),
                    () {
                  logic.goToLegalPersonPage();
                }),
                Container(
                  child: _itemView('企业创建人信息', '企业创建人信息', () {
                    Get.to(EnterpriseCreator());
                  }),
                ),
                Offstage(
                  offstage: state.type != 1,
                  child: _itemViewIcon("企业标志", "设置企业简称、设置企业标志", () {
                    logic.goToHeaderNamePage();
                  }),
                ),
              ],
            ),
          ),
        ],
      );
    });
  }

  Widget _itemView(String title, String describe, VoidCallback onTap,
      {double marginTop = 15}) {
    return GlobalCardWidget(
      isHeaderVis: true,
      onTab: onTap,
      backgroundColor: const Color(0xFFF2F1F6),
      marginLeft: 25,
      marginRight: 25,
      marginTop: marginTop,
      paddingAll: 20,
      centerWidget: _itemContent(title, describe, () {
        onTap();
      }, marginTop: 15),
      elevation: 0,
      hintFillWidget: Text(
        "去填写",
        style: TextStyle(color: const Color(0xffB4BAC6)),
      ),
    );
  }

  Widget _itemViewIcon(String title, String describe, VoidCallback onTap,
      {double marginTop = 15}) {
    return GlobalCardWidget(
      isHeaderVis: true,
      isVisHintFill: false,
      onTab: onTap,
      backgroundColor: const Color(0xFFF2F1F6),
      marginLeft: 25,
      marginRight: 25,
      marginTop: marginTop,
      paddingAll: 20,
      elevation: 0,
      centerWidget: _itemContent(title, describe, () {
        onTap();
      }, marginTop: 15),
      hintFillWidget: SizedBox(
        width: 44,
        height: 44,
        child: Offstage(
          offstage: true,
          child: Image(
              fit: BoxFit.cover,
              image: NetworkImage(state.logoUrl),
              errorBuilder: (context, a, b) {
                return AssetImageWidget(imgFileName: 'ic_enterprise_ph');
              }),
        ),
      ),
    );
  }

  Widget _itemContent(String title, String describe, VoidCallback onTap,
      {double marginTop = 15}) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(
          title,
          style: TextStyle(fontSize: 16),
        ),
        vGap10,
        Text(
          describe,
          style: TextStyle(fontSize: 12, color: const Color(0xffA4A8B1)),
        ),
      ],
    );
  }
}
