import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/asset_image_widget.dart';
import 'package:account_center/widget/global_card_widget.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'join_or_new_enterprise_logic.dart';

///创建/加入企业
class JoinOrNewEnterprisePage extends StatelessWidget {
  final logic = Get.find<JoinOrNewEnterpriseLogic>();
  final state = Get.find<JoinOrNewEnterpriseLogic>().state;

  JoinOrNewEnterprisePage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      backgroundColor: Colors.white,
      appBar: MyAppBar('加入/创建企业'),
      body: _bodyContent(),
    );
  }

  Widget _bodyContent() {
    return Column(
      children: [_itemBanner(), vGap15, Expanded(child: _listView())],
    );
  }

  Widget _itemBanner() {
    return SizedBox(
        width: double.infinity,
        height: 200,
        child: AssetImageWidget(
          imgFileName: 'ic_enterprise_bg',
          fit: BoxFit.cover,
        ));
  }

  Widget _listView() {
    return ListView.builder(
      itemBuilder: (context, index) {
        return _item(index, logic.color(index));
      },
      itemCount: logic.list.length,
    );
  }

  Widget _item(int index, int color) {
    return GlobalCardWidget(
      backgroundColor: Color(0xFFF2F1F6),
      isHeaderVis: true,
      elevation: 0,
      marginTop: 15,
      marginLeft: 25,
      marginRight: 25,
      paddingH: 20,
      paddingV: 15,
      onTab: () {
        logic.goToPage(index);
      },
      centerWidget: Row(children: [
        Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Text.rich(TextSpan(children: [
              TextSpan(
                  text: logic.title(index),
                  style: TextStyle(
                      fontSize: 16,
                      fontWeight: FontWeight.bold,
                      color: Color(color))),
              TextSpan(
                  text: logic.title2(index),
                  style: TextStyle(fontSize: 16, fontWeight: FontWeight.bold))
            ])),
            vGap5,
            Text(
              logic.describe(index),
              style: TextStyle(fontSize: 12, color: Colors.grey[500]),
            ),
          ],
        ),
      ]),
    );
  }
}
