import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/asset_image_widget.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

import 'join_enterprise_record_logic.dart';

///加入企业记录
class JoinEnterpriseRecordPage extends StatelessWidget {
  final logic = Get.find<JoinEnterpriseRecordLogic>();
  final state = Get.find<JoinEnterpriseRecordLogic>().state;

  JoinEnterpriseRecordPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: MyAppBar('加入企业记录'),
      body: _bodyContent(),
    );
  }

  Widget _bodyContent() {
    return MyListViewPublic(itemBuilder: (context, index, item) {
      logic.textUpdate(item);
      return _itemView(item);
    }, requestData: (page, pageSize, success, error) {
      logic.enterpriseRecordListRequest(page, pageSize, success);
    });
  }

  Widget _itemView(dynamic item) {
    return Container(
      decoration: BoxDecoration(
          color: Colors.white, borderRadius: BorderRadius.circular(8)),
      margin: EdgeInsets.only(left: 10, top: 10, right: 10),
      padding: EdgeInsets.all(20),
      child: InkWell(
        borderRadius: BorderRadius.all(Radius.circular(10)),
        onTap: () {
          logic.authStateIcon(item['id']);
        },
        child: Column(
          children: [
            Row(
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                AssetImageWidget(
                  width: 54,
                  height: 18,
                  imgFileName: logic.authStateIcon(
                    item['authStatus'],
                  ),
                ),
                hGap8,
                Flexible(
                  child: Text(
                    item['companyName'],
                    style: TextStyle(color: Color(0xFF171A1D), fontSize: 16),
                  ),
                ),
              ],
            ),
            Visibility(
              visible: item['authStatus'] == 30 &&
                  item['authContent']?.toString().isNotEmpty == true,
              child: Container(
                width: double.infinity,
                margin: EdgeInsets.only(top: 10),
                decoration: BoxDecoration(
                  color: Color(0xFFFFF2F4),
                  borderRadius: BorderRadius.circular(4),
                ),
                padding: EdgeInsets.symmetric(vertical: 8, horizontal: 10),
                child: Text(
                  item['authContent'] ?? '-',
                  style: TextStyle(color: Color(0xFFF48182), fontSize: 12),
                ),
              ),
            ),
            _contentRow('申请时间：', item['createTime'] ?? '-'),
            _contentRow('申请编号：', item['applyNo'] ?? '-'),
          ],
        ),
      ),
    );
  }

  Widget _contentRow(String title, String content) {
    return Container(
      margin: EdgeInsets.only(top: 10),
      child: Row(
        children: [
          Text(
            title,
            style: TextStyle(fontSize: 12, color: const Color(0xFF68717C)),
          ),
          hGap5,
          Text(content),
        ],
      ),
    );
  }

  ///头像标题
  Widget _headerWidget(String title, {String? headerUrl}) {
    return Container(
      margin: EdgeInsets.only(top: 4),
      padding: EdgeInsets.only(left: 25, right: 25),
      child: Row(
        children: [
          ImageWidget.loadNetImage(
              'https://img0.baidu.com/it/u=1694074520,2517635995&fm=253&app=138&size=w931&n=0&f=JPEG&fmt=auto?sec=1657472400&t=3b8cee3f0f6a844e69f3b43dff3d8465',
              type: ImageTransformerType.rect,
              width: 33,
              height: 33),
          hGap15,
          Expanded(
              child: Text(
            title,
            maxLines: 1,
            style: TextStyle(
                fontWeight: FontWeight.w600,
                color: Colors.black,
                fontSize: 18,
                overflow: TextOverflow.ellipsis),
          ))
        ],
      ),
    );
  }

  ///查看驳回原因
  Widget itemBHBtn(bool state) {
    return Offstage(
      offstage: state,
      child: InkWell(
        onTap: () {},
        child: Container(
            alignment: Alignment.center,
            width: double.infinity,
            padding: EdgeInsets.symmetric(vertical: 12),
            child: Text('查看驳回原因')),
      ),
    );
  }
}
