import 'package:account_center/account_center.dart';
import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_util.dart';

import 'join_enterprise_state.dart';

class JoinEnterpriseLogic extends GetxController {
  final JoinEnterpriseState state = JoinEnterpriseState();
  String? companyNo;
  @override
  void onInit() {
    super.onInit();
    var data = Get.arguments;
    state.name = getUserName();
    state.mobile = getUserMobile();
    state.companyName = data['companyName'];
    state.companyLogo = data['companyLogo'];
    companyNo = data['companyNo']?.toString();
  }

  void joinEnterprise() {
    commitApplyRequest();
  }

  void commitApplyRequest() {
    fetch(Method.post, url: HttpApi.joinEnterprise, params: {
      'companyNo': companyNo,
      'applyContent': state.controllerTip.text,
      'userName': state.name,
      'mobile': state.mobile,
      'productCode': AccountCenter.ownerProductCode
    }, onSuccess: (data) {
      ToastUtil.showToast('已提交申请，请耐心等待企业审核');
      Get.back();
    });
  }
}
