import 'package:account_center/page/enterprise/join_or_new_enterprise_page/enterprise_see_widget.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/form/form_row.dart';
import 'package:account_center/widget/form/form_select.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'enterprise_proxy_person_see_logic.dart';

///查看  企企业代理人信息
class EnterpriseProxyPersonSeePage extends StatelessWidget {
  final logic = Get.find<EnterpriseProxyPersonSeeLogic>();
  final state = Get.find<EnterpriseProxyPersonSeeLogic>().state;

  EnterpriseProxyPersonSeePage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: MyAppBar('企业代理人信息'),
      body: _bodyContent(context),
    );
  }

  Widget _bodyContent(context) {
    return GetBuilder<EnterpriseProxyPersonSeeLogic>(builder: (logic) {
      return Container(
        padding: EdgeInsets.only(top: 10),
        child: SingleChildScrollView(
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: [
              EnterpriseInfoWidget.formRow('姓名', state.agentName),
              EnterpriseInfoWidget.formRow('手机号', state.agentMobile),
              EnterpriseInfoWidget.formRow('身份证号', state.agentCardNo),
              FormRow(
                title: '身份证',
                crossAxisAlignment: CrossAxisAlignment.start,
                child: Column(
                  mainAxisSize: MainAxisSize.min,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    EnterpriseInfoWidget.idImage(state.agentCardFrontImg),
                    vGap20,
                    EnterpriseInfoWidget.idImage(state.agentCardBackImg),
                  ],
                ),
              ),
              FormSelect(
                title: '企业注册确认函',
                content: logic.fileName,
                onTap: () {
                  logic.preView();
                },
                onlyShow: logic.fileName.isEmpty,
              )
            ],
          ),
        ),
      );
    });
  }
}
