import 'package:account_center/account_center.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/certificate_select.dart';
import 'package:account_center/widget/form/form_input.dart';
import 'package:account_center/widget/form/form_row.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'enterprise_legal_person_logic.dart';

///创建企业->填写企业基础信息->企业法人信息
class EnterpriseLegalPersonPage extends StatelessWidget {
  final logic = Get.find<EnterpriseLegalPersonLogic>();
  final state = Get.find<EnterpriseLegalPersonLogic>().state;

  EnterpriseLegalPersonPage({super.key});

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        Get.back();
        return false;
      },
      child: MyScaffold(
        appBar: MyAppBar(
          '企业法人信息',
          onBack: () {
            Get.back();
          },
        ),
        body: _bodyContent(context),
      ),
    );
  }

  Widget _bodyContent(context) {
    return GetBuilder<EnterpriseLegalPersonLogic>(builder: (logic) {
      return Container(
        padding: EdgeInsets.only(top: 10),
        child: Column(
          children: [
            Expanded(
              child: SingleChildScrollView(
                child: Column(
                  children: [
                    FormInput(
                      maxLength: 10,
                      title: '姓名',
                      controller: state.controllerName,
                      focusNode: state.nodeName,
                    ),
                    FormInput(
                      regExp: "[0-9]",
                      inputType: TextInputType.phone,
                      title: '手机号',
                      controller: state.controllerPhone,
                      focusNode: state.nodePhone,
                      maxLength: 11,
                    ),
                    FormInput(
                      maxLength: 18,
                      title: '身份证号',
                      controller: state.controllerIDCard,
                      focusNode: state.nodeIDCard,
                    ),
                    FormRow(
                      title: '身份证',
                      child: Text(''),
                    ),
                    _businessLicenseWidget('头像面', '上传身份证头像面', true, 'ic_id_up',
                        state.cardUrlUpPath),
                    _businessLicenseWidget('国徽面', '上传身份证国徽面', false,
                        'ic_id_down', state.cardUrlDownPath),
                  ],
                ),
              ),
            ),
            _itemBottomBtn(context)
          ],
        ),
      );
    });
  }

  ///身份证
  Widget _businessLicenseWidget(
      String title, String subTitle, bool isUp, String path, String? urlImage) {
    return CertificateSelect(
        title: title,
        secondTitle: subTitle,
        url: urlImage ?? '',
        bagUrl: path,
        onTap: () {
          logic.cameraCapture(isUp);
        },
        onDelete: () {
          logic.deleteImage(isUp);
        });
  }

  ///底部按钮
  Widget _itemBottomBtn(context) {
    return ButtonPublicRadius(
      margin: EdgeInsets.only(left: 25, bottom: 25, right: 25),
      onPress: () {
        logic.completed();
      },
      text: "确定",
    );
  }
}
