import 'package:account_center/style/style_params.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'invite_members_logic.dart';

class InviteMembersPage extends StatelessWidget {
  final logic = Get.find<InviteMembersLogic>();
  final state = Get.find<InviteMembersLogic>().state;

  InviteMembersPage({super.key});

  final textStyle1 = TextStyle(
      fontSize: 18, color: Color(0xFF344254), fontWeight: FontWeight.w500);
  final textStyle2 = TextStyle(
      fontSize: 36, color: Color(0xFF1F59EF), fontWeight: FontWeight.w500);
  final textStyle3 = TextStyle(fontSize: 14, color: Color(0xFFA4A8B1));
  final textStyle4 = TextStyle(fontSize: 14, color: Color(0xFF1F59EF));
  final textStyle5 = TextStyle(fontSize: 18, color: Color(0xFF171A1D));

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: MyAppBar("邀请人员"),
      children: [
        GetBuilder<InviteMembersLogic>(builder: (logic) {
          return Container(
            decoration: BoxDecoration(
              color: Colors.white,
              borderRadius: BorderRadius.circular(8),
            ),
            margin: const EdgeInsets.only(top: 10, left: 10, right: 10),
            padding: const EdgeInsets.only(left: 10, right: 10),
            child: Column(
              children: [
                vGap30,
                Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Text(
                      "我的邀请码",
                      style: textStyle1,
                    ),
                  ],
                ),
                vGap15,
                Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Text(
                      state.invitationCode,
                      style: textStyle2,
                    ),
                  ],
                ),
                vGap15,
                Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Text(
                      "${state.invalidTime} 到期",
                      style: textStyle3,
                    ),
                  ],
                ),
                vGap15,
                InkWell(
                  onTap: () {
                    Get.dialog(_invitationDialog());
                  },
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: [
                      Text("重新生成邀请码", style: textStyle4),
                    ],
                  ),
                ),
                vGap15,
                ButtonPublicRadius(
                  text: "复制邀请码",
                  onPress: () {
                    Clipboard.setData(
                        ClipboardData(text: state.invitationCode));
                    ToastUtil.showToast("复制成功");
                  },
                ),
                vGap25
              ],
            ),
          );
        })
      ],
    );
  }

  // 生成邀请码对话框
  Widget _invitationDialog() {
    return GetBuilder<InviteMembersLogic>(builder: (logic) {
      return Dialog(
        child: Container(
          height: 340,
          decoration: BoxDecoration(
            color: Colors.white,
            borderRadius: BorderRadius.circular(8),
          ),
          padding:
              const EdgeInsets.only(left: 10, right: 10, top: 10, bottom: 20),
          child: Column(
            children: [
              Row(
                mainAxisAlignment: MainAxisAlignment.end,
                children: [
                  InkWell(
                    onTap: () {
                      Get.back();
                    },
                    child: SizedBox(
                        height: 30,
                        width: 30,
                        child: Icon(Icons.close, color: Color(0xFFA4A8B1))),
                  ),
                ],
              ),
              Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  Text(
                    "请选择验证码的时效",
                    style: textStyle5,
                  ),
                ],
              ),
              vGap15,
              Container(
                padding: const EdgeInsets.only(left: 30, right: 30),
                height: 120,
                width: double.infinity,
                child: GridView(
                  gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                      crossAxisCount: 2,
                      mainAxisSpacing: 20.0,
                      crossAxisSpacing: 20.0,
                      childAspectRatio: 2.5),
                  children: [
                    _invitationItem("1天", 1),
                    _invitationItem("7天", 7),
                    _invitationItem("15天", 15),
                    _invitationItem("30天", 30),
                  ],
                ),
              ),
              vGap15,
              ButtonPublicRadius(
                text: "生成邀请码",
                onPress: () {
                  logic.generateInviteCode();
                  Get.back();
                },
              ),
              vGap10,
              Text("生成新的邀请码后，旧邀请码将无法使用", style: textStyle3),
            ],
          ),
        ),
      );
    });
  }

  _invitationItem(String text, int days) {
    var isSelect = state.effectDays == days;
    return InkWell(
      onTap: () {
        state.effectDays = days;
        logic.update();
      },
      child: Container(
        alignment: Alignment.center,
        decoration: BoxDecoration(
          color: Color(0xFFF5F6FA),
          borderRadius: BorderRadius.circular(8),
          border: Border.all(
            color: isSelect ? StyleParams.themeColor : Color(0xFFF5F6FA),
            width: 1,
          ),
        ),
        child: Text(
          text,
          style: TextStyle(
              color: isSelect ? StyleParams.themeColor : Color(0xFF344254),
              fontSize: 15),
        ),
      ),
    );
  }
}
