import 'package:account_center/common/res/colors.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

import 'enterprise_product_logic.dart';

class EnterpriseProductPage extends StatelessWidget {
  final logic = Get.find<EnterpriseProductLogic>();
  final state = Get.find<EnterpriseProductLogic>().state;

  EnterpriseProductPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: MyAppBar("公司产品"),
      body: _bodyContent(context),
    );
  }

  Widget _bodyContent(context) {
    return MyListViewPublic(
        itemBuilder: (context, index, data) {
          return _itemViewPro(data);
        },
        requestData: (page, pageSize, success, error) {
          logic.productListRequest(page, pageSize, success);
        },
        canLoadMore: false);
  }

  ///产品列表条目
  Widget _itemViewPro(entity) {
    return InkWell(
      onTap: () {
        logic.goToProductDetailsPage(entity);
        //logic.itemClick(entity);
      },
      child: Container(
        margin: EdgeInsets.only(bottom: 1),
        padding: EdgeInsets.symmetric(horizontal: 20, vertical: 10),
        color: Colors.white,
        child: Row(
          children: [
            ImageLoad.productIcon(
              entity['productImgUrl'],
              width: 60,
              height: 60,
              type: ImageTransformerType.rect,
            ),
            hGap15,
            Expanded(
                child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(
                  entity['productName'] ?? "",
                  style: TextStyle(fontSize: 16, fontWeight: FontWeight.bold),
                ),
                vGap8,
                Text(
                  entity['productDescribe'] ?? "",
                  style: TextStyle(fontSize: 12, color: RColors.hintColor),
                )
              ],
            )),
            Icon(
              Icons.arrow_forward_ios_rounded,
              color: Color(0xFFB4BAC6),
              size: 20,
            ),
          ],
        ),
      ),
    );
  }
}
