import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/enterprise/certification/certification_status.dart';
import 'package:account_center/page/enterprise/certification/signature/signature_status.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/button_public_radius_outline.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/asset_image_widget.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'signature_logic.dart';

class SignaturePage extends StatelessWidget {
  final logic = Get.find<SignatureLogic>();

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: MyAppBar("企业签章"),
      body: GetBuilder<SignatureLogic>(builder: (logic) {
        switch (logic.certificationStatus) {
          case SignatureStatus.first:
            return CertificationStatusWidget(
              image: 'certification_not',
              title: '未认证',
              content: '签章认证将跳转到第三方服务平台。',
              buttonText: '去签章认证',
              onClick: () {
                _showConfirmDialog();
              },
            );
          case SignatureStatus.doing:
          case SignatureStatus.outTime:
            return CertificationStatusWidget(
              image: 'certification_doing',
              title: '办理中',
              content: '签章授权正在办理中…',
              buttonText: '重新授权',
              onClick: () {
                _showConfirmDialog();
              },
            );
          // case SignatureStatus.outTime:
          //   return CertificationStatusWidget(
          //     image: 'certification_doing',
          //     title: '超时',
          //     content: '签章授权超时',
          //     buttonText: '重新授权',
          //     onClick: () {
          //       _showConfirmDialog();
          //     },
          //   );
          case SignatureStatus.normal:
          case SignatureStatus.loseEfficacy:
          case SignatureStatus.cancel:
          case SignatureStatus.exception:
            return signatureStatusContainer(logic);
          default:
            return Container();
        }
      }),
    );
  }

  Container signatureStatusContainer(SignatureLogic logic) {
    return Container(
      margin: EdgeInsets.all(15),
      width: double.infinity,
      decoration: BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.circular(10),
      ),
      child: Stack(
        alignment: Alignment.center,
        children: [
          Column(
            mainAxisSize: MainAxisSize.min,
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              SizedBox(
                height: 24,
              ),
              ImageLoad.loadNetImage(
                logic.sealUrl,
                height: 140,
                width: 140,
              ),
              SizedBox(
                height: 15,
              ),
              Text(
                logic.sealName,
                style: TextStyle(
                    fontSize: 18,
                    color: Color(0xff344254),
                    fontWeight: FontWeight.w500),
              ),
              SizedBox(
                height: 10,
              ),
              Text(
                '创建时间：${logic.createTime}',
                style: TextStyle(
                  color: Color(0xff909399),
                  fontSize: 13,
                ),
              ),
              SizedBox(
                height: 10,
              ),
              Text(
                '有效时间：${logic.limitTime}',
                style: TextStyle(
                  color: Color(0xff909399),
                  fontSize: 13,
                ),
              ),
              SizedBox(
                height: 15,
              ),
            ],
          ),
          Positioned(
            top: 0,
            right: 0,
            child: AssetImageWidget(
              imgFileName: SignatureStatus.normal == logic.certificationStatus
                  ? 'seal_normal'
                  : 'seal_lose_efficacy',
              width: 66,
            ),
          )
        ],
      ),
    );
  }

  void _showConfirmDialog() {
    Get.dialog(Dialog(
      child: Container(
        padding: EdgeInsets.symmetric(horizontal: 30),
        decoration: BoxDecoration(
            color: Colors.white, borderRadius: BorderRadius.circular(10)),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            SizedBox(
              height: 30,
            ),
            Container(
              padding: EdgeInsets.all(5),
              child: Text(
                '您好！根据《中华人民共和国电子签名法》和其他相关法律、法规的规定，办理签章需要国家指定机构授权。如确认办理，将跳转到第三方平台进行授权！',
                style: TextStyle(color: Color(0xff909399), fontSize: 15),
              ),
            ),
            SizedBox(
              height: 25,
            ),
            Row(
              children: [
                Expanded(
                  child: ButtonPublicRadiusOutline(
                    text: '否',
                    onPress: () {
                      Get.back();
                    },
                    margin: EdgeInsets.all(0),
                  ),
                ),
                SizedBox(
                  width: 15,
                ),
                Expanded(
                  child: ButtonPublicRadius(
                    text: '是',
                    onPress: () {
                      Get.back();
                      logic.toCertificationSign();
                    },
                    margin: EdgeInsets.all(0),
                  ),
                )
              ],
            ),
            SizedBox(
              height: 20,
            )
          ],
        ),
      ),
    ));
  }
}
