import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/utils/map_extension.dart';
import 'package:account_center/common/utils/progress_loading.dart';
import 'package:account_center/common/utils/reg_exp.dart';
import 'package:account_center/page/account_company/company_home/company_manage_logic.dart';
import 'package:account_center/page/web/custom_webview.dart';
import 'package:account_center/widget/confirm_dialog.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class EnterpriseMessageCertificationLogic extends GetxController {
  var legalPersonNode = FocusNode();
  var legalPersonController = TextEditingController();

  var legalPersonPhoneNode = FocusNode();
  var legalPersonPhoneController = TextEditingController();

  var legalPersonIdNode = FocusNode();
  var legalPersonIdController = TextEditingController();

  var agentPersonNode = FocusNode();
  var agentPersonController = TextEditingController();

  var agentPersonPhoneNode = FocusNode();
  var agentPersonPhoneController = TextEditingController();

  var agentPersonIdNode = FocusNode();
  var agentPersonIdController = TextEditingController();

  var enterpriseNameNode = FocusNode();
  var enterpriseNameController = TextEditingController();

  var enterpriseIdNode = FocusNode();
  var enterpriseTypeController = TextEditingController();

  var check = false;

  @override
  void onInit() {
    _requestCompanyData();
    super.onInit();
  }

  void _requestCompanyData() {
    fetch(Method.get,
        url: HttpApi.getLoginEsignCompanyIdentifyData,
        queryParameters: {}, onSuccess: (response) {
      response as Map<String, dynamic>;
      legalPersonController.text = response.optString('legalName');
      legalPersonPhoneController.text = response.optString('legalMobile');
      legalPersonIdController.text = response.optString('legalCardNo');
      agentPersonController.text = response.optString('agentName');
      agentPersonPhoneController.text = response.optString('agentMobile');
      agentPersonIdController.text = response.optString('agentCardNo');
      enterpriseNameController.text = response.optString('companyName');
      enterpriseTypeController.text = response.optString('companyGroupCode');
      update();
    });
  }

  void _requestCertification() {
    showLoading();
    fetch(Method.post, url: HttpApi.saveEsignCompanyIdentifyFlow, params: {
      'legalName': legalPersonController.text,
      'legalMobile': legalPersonPhoneController.text,
      'legalCardNo': legalPersonIdController.text.toUpperCase(),
      'agentName': agentPersonController.text,
      'agentMobile': agentPersonPhoneController.text,
      'agentCardNo': agentPersonIdController.text.toUpperCase(),
      'companyName': enterpriseNameController.text,
      'companyGroupCode': enterpriseTypeController.text,
      'redirectUrl': 'https://www.baidu.com'
    }, onSuccess: (response) {
      response as Map<String, dynamic>;
      if (response['authShortUrl'] != null) {
        Get.to(CustomWebView(url: response.optString('authShortUrl')))
            ?.then((value) {
          dismissLoading();
          Future.delayed(Duration(milliseconds: 1000)).then((a) {
            ConfirmDialog(
              content: '是否完成认证',
              confirmButtonText: '已完成',
              confirm: () {
                Get.find<CompanyManageLogic>().getCompanyUserByNo();
                Get.back();
                Get.back();
              },
            ).show();
          });
        });
        // WebUtil.launchInBrowser(
        //   response.optString('authShortUrl'),
        // ).then((value) {
        //   dismissLoading();
        //   Future.delayed(Duration(milliseconds: 1000)).then((a) {
        //     ConfirmDialog(
        //       content: '是否完成认证',
        //       confirmButtonText: '已完成',
        //       confirm: () {
        //         Get.find<EnterpriseManagementLogic>().getCompanyUserByNo();
        //         Get.back();
        //         Get.back();
        //       },
        //     ).show();
        //   });
        // });
      }
    }, onError: (code, message) {
      dismissLoading();
    });
  }

  void confirm() {
    check = true;
    update();
    if (legalPersonController.text.isEmpty) {
      return;
    }
    if (legalPersonPhoneController.text.length != 11) {
      return;
    }
    if (!RegExpUtil.checkIdCard(legalPersonIdController.text)) {
      return;
    }
    if (agentPersonController.text.isEmpty) {
      return;
    }
    if (agentPersonPhoneController.text.length != 11) {
      return;
    }
    if (!RegExpUtil.checkIdCard(agentPersonIdController.text)) {
      return;
    }
    if (enterpriseNameController.text.isEmpty) {
      return;
    }
    if (enterpriseTypeController.text.isEmpty) {
      return;
    }
    _requestCertification();
  }
}
