import 'package:account_center/account_center.dart';
import 'package:account_center/common/utils/alert_util.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:account_center/widget/pdf_page.dart';
import 'package:flutter/material.dart';

class StampHistoryItem extends StatelessWidget {
  final dynamic item;
  const StampHistoryItem({super.key, this.item});

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.only(left: 15, right: 15, bottom: 10, top: 15),
      margin: const EdgeInsets.only(bottom: 10),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8),
        color: Colors.white,
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Container(
            padding: const EdgeInsets.symmetric(vertical: 3, horizontal: 10),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(3),
              color: StyleParams.themeColor,
            ),
            child: Text(
              item?['signatureName'] ?? '-',
              style: TextStyle(
                  color: Colors.white,
                  fontSize: 14,
                  fontWeight: FontWeight.w400),
            ),
          ),
          vGap11,
          Text(
            '签名调用时间: ${item?['createTime'] ?? '-'}',
            style: TextStyle(
                color: Color(0xff344254),
                fontSize: 13,
                fontWeight: FontWeight.w400),
          ),
          vGap12,
          Container(
            padding: const EdgeInsets.all(10),
            color: Color(0xffF4F8FD),
            child: Column(
              children: [
                Row(
                  children: [
                    _createWidget('产品', item?['productName']),
                    _createWidget('文件', item?['templateName']),
                  ],
                ),
                vGap5,
                Row(
                  children: [
                    _createWidget('编号', getTXTString(item?['relationNo'])),
                    _createWidget('合同', '合同预览', canSelect: true),
                  ],
                )
              ],
            ),
          ),
        ],
      ),
    );
  }

  Widget _createWidget(String? title, String? value, {bool canSelect = false}) {
    return Expanded(
        child: GestureTapWidget(
      onTap: () {
        if (!canSelect) {
          return;
        }
        if (getTXTString(item?['signUrl']).isEmpty) {
          AlertUtil.showCenterToast('合同地址无效');
          return;
        }
        Get.to(() => PdfPage(url: item?['signUrl'] ?? '', title: '合同预览'));
      },
      child: Row(
        children: [
          Text(
            title ?? '',
            style: TextStyle(
                color: Color(0xff687582),
                fontSize: 12,
                fontWeight: FontWeight.w400),
          ),
          hGap10,
          Expanded(
              child: Text(
            value ?? '',
            style: TextStyle(
                color: canSelect ? StyleParams.themeColor : Color(0xff344254),
                fontSize: 13,
                fontWeight: FontWeight.w500),
          )),
        ],
      ),
    ));
  }
}
