import 'package:account_center/account_center.dart';
import 'package:account_center/common/utils/alert_util.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

import '../../company_auth/widget/common/company_define.dart';

class StampNameAlert extends StatefulWidget {
  final StringCallBack? confirmBlock;
  const StampNameAlert({super.key, this.confirmBlock});

  @override
  State<StatefulWidget> createState() {
    return _StampNameAlert();
  }
}

class _StampNameAlert extends State<StampNameAlert> {
  final TextEditingController _controller = TextEditingController();

  @override
  Widget build(BuildContext context) {
    return Container(
      color: Colors.black.withOpacity(0.15),
      alignment: Alignment.center,
      child: Container(
        margin: const EdgeInsets.symmetric(horizontal: 30),
        padding: EdgeInsets.all(20),
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(10),
          color: Colors.white,
        ),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            Row(
              mainAxisAlignment: MainAxisAlignment.end,
              children: [
                GestureTapWidget(
                  onTap: () {
                    Get.back();
                  },
                  child: Icon(
                    Icons.close,
                    size: 20,
                    color: Color(0xffC0C0C0),
                  ),
                )
              ],
            ),
            vGap3,
            Text(
              '企业签章',
              style: TextStyle(
                  color: Color(0xff171A1D),
                  fontSize: 18,
                  fontWeight: FontWeight.w500),
            ),
            vGap10,
            Text(
              '签章名称不可修改，请谨慎填写',
              style: TextStyle(
                  color: Color(0xffFFA722),
                  fontSize: 14,
                  fontWeight: FontWeight.w400),
            ),
            vGap10,
            TextField(
              controller: _controller,
              style: TextStyle(
                color: Color(0xff171A1D),
                fontSize: 14,
                fontWeight: FontWeight.w400,
              ),
              maxLength: 8,
              autofocus: true,
              decoration: InputDecoration(
                filled: true,
                fillColor: Color(0xffF5F6FA),
                border: UnderlineInputBorder(borderSide: BorderSide.none),
                hintText: '请输入签章名称',
                hintStyle: TextStyle(
                  color: Color(0xffCDD0D6),
                  fontSize: 14,
                  fontWeight: FontWeight.w400,
                ),
              ),
            ),
            vGap24,
            GestureTapWidget(
              onTap: () {
                if (_controller.text.length < 2) {
                  AlertUtil.showCenterToast('当前印章名称字符长度太短，请重新输入');
                  return;
                }
                Get.back();
                if (widget.confirmBlock != null) {
                  widget.confirmBlock!(_controller.text);
                }
              },
              child: Container(
                alignment: Alignment.center,
                height: 50,
                margin: EdgeInsets.symmetric(horizontal: 15),
                decoration: BoxDecoration(
                  color: StyleParams.themeColor,
                  borderRadius: BorderRadius.circular(8),
                ),
                child: Text(
                  '确定',
                  style: TextStyle(
                      color: Colors.white,
                      fontSize: 15,
                      fontWeight: FontWeight.w600),
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }
}
