import 'package:account_center/common/utils/image_load.dart';
import 'package:flutter/material.dart';

class StampItem extends StatelessWidget {
  final dynamic item;
  const StampItem({super.key, this.item});

  @override
  Widget build(BuildContext context) {
    double size = (MediaQuery.of(context).size.width - 55) / 2;
    return SizedBox(
      width: size,
      child: Column(
        mainAxisSize: MainAxisSize.min,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          // Text(
          //   item?['name'],
          //   maxLines: 1,
          //   overflow: TextOverflow.ellipsis,
          //   style: TextStyle(
          //       color: Colors.black, fontSize: 14, fontWeight: FontWeight.w500),
          // ),
          // vGap10,
          Container(
            width: size,
            height: size,
            clipBehavior: Clip.hardEdge,
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(4),
              color: Color(0xffF3F6FA),
            ),
            child: ImageLoad.loadNetImage(item ?? ''),
          )
        ],
      ),
    );
  }
}
