import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

import '../company_auth/widget/common/attribute_string.dart';
import '../company_auth/widget/common/company_define.dart';
import '../company_auth/widget/common/input_field.dart';
import '../company_home/widget/company_nav.dart';
import 'company_sign_logic.dart';

class CompanySignView extends GetView<CompanySignLogic> {
  const CompanySignView({super.key});

  CompanySignLogic get _logic => controller;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: CompanyManageNav.createNav('签章授权'),
      body: SingleChildScrollView(
        child: GetBuilder(
          init: _logic,
          builder: (controller) {
            return Column(
              children: [
                vGap10,
                Container(
                  padding: const EdgeInsets.only(
                      left: 20, right: 20, top: 20, bottom: 10),
                  color: Colors.white,
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      CLXAttributeString()
                          .add('请确认', normalStyle)
                          .add('企业', lightStyle)
                          .add('信息', normalStyle)
                          .richText,
                      vGap10,
                      InputField(
                        title: '企业名称',
                        value: _logic.busniessName,
                        enabled: false,
                      ),
                      InputField(
                        title: '信用代码',
                        value: _logic.busniessCode,
                        enabled: false,
                      ),
                      InputField(
                        title: '法人姓名',
                        value: _logic.legalName,
                        enabled: false,
                      ),
                      InputField(
                        title: '签章名称',
                        value: '公章',
                        enabled: false,
                      )
                    ],
                  ),
                ),
                vGap10,
                Container(
                  padding: const EdgeInsets.only(
                      left: 20, right: 20, top: 20, bottom: 10),
                  color: Colors.white,
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      CLXAttributeString()
                          .add('请确认', normalStyle)
                          .add('代理人', lightStyle)
                          .add('信息', normalStyle)
                          .richText,
                      vGap10,
                      InputField(
                        title: '姓名',
                        value: _logic.agentName,
                        enabled: false,
                      ),
                      InputField(
                        title: '身份证号',
                        value: _logic.agentIdCard,
                        enabled: false,
                      ),
                      InputField(
                        title: '手机号',
                        value: _logic.agentPhone,
                        enabled: false,
                      ),
                      InputField(
                        title: '验证码',
                        maxLength: 6,
                        value: _logic.sms,
                        keyboardType: TextInputType.number,
                        rightWidget: GestureTapWidget(
                          onTap: _logic.sendSms,
                          child: Text(
                            _logic.btnTitle,
                            style: TextStyle(
                                color: StyleParams.themeColor,
                                fontSize: 14,
                                fontWeight: FontWeight.w500),
                          ),
                        ),
                        onChanged: _logic.receiveSms,
                      )
                    ],
                  ),
                ),
                vGap50,
                GestureTapWidget(
                  onTap: _logic.applySign,
                  child: Container(
                    alignment: Alignment.center,
                    height: 50,
                    margin: EdgeInsets.only(
                      left: 25,
                      right: 25,
                      bottom: MediaQuery.of(context).padding.bottom + 15,
                    ),
                    decoration: BoxDecoration(
                      color: StyleParams.themeColor,
                      borderRadius: BorderRadius.circular(8),
                    ),
                    child: Text(
                      '开始授权',
                      style: TextStyle(
                          color: Colors.white,
                          fontSize: 15,
                          fontWeight: FontWeight.w600),
                    ),
                  ),
                ),
              ],
            );
          },
        ),
      ),
    );
  }
}
