import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

class InfoAlert extends StatelessWidget {
  final EdgeInsetsGeometry? margin;
  final EdgeInsetsGeometry? padding;
  final Color color;
  final double radius;
  final String? title;
  final String? description;
  final Widget? child;
  final List<Widget> actions;

  const InfoAlert({
    super.key,
    this.margin = const EdgeInsets.symmetric(horizontal: 30),
    this.color = Colors.white,
    this.padding = const EdgeInsets.all(20),
    this.radius = 10,
    this.title,
    this.child,
    this.description,
    required this.actions,
  });

  @override
  Widget build(BuildContext context) {
    List<Widget> children = [];
    for (var i = 0; i < actions.length; i++) {
      children.add(actions[i]);
      children.add(hGap10);
    }
    children.removeLast();
    return Column(
      mainAxisAlignment: MainAxisAlignment.center,
      children: [
        Container(
          width: double.infinity,
          margin: margin,
          padding: padding,
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(radius),
            color: color,
          ),
          child: Column(
            children: [
              Visibility(
                visible: title?.isNotEmpty == true,
                child: Text(
                  title ?? '',
                  style: TextStyle(
                      color: Color(0xff171A1D),
                      fontSize: 17,
                      fontWeight: FontWeight.w500),
                ),
              ),
              Visibility(
                visible: title?.isNotEmpty == true,
                child: vGap10,
              ),
              Visibility(
                visible: description?.isNotEmpty == true,
                child: Text(
                  description ?? '',
                  style: TextStyle(
                      color: Color(0xff171A1D),
                      fontSize: 17,
                      fontWeight: FontWeight.w500),
                ),
              ),
              if (child != null) child!,
              vGap20,
              Row(
                children: children,
              )
            ],
          ),
        ),
      ],
    );
  }
}

enum AlertActionType { normal, light }

class AlertAction extends StatelessWidget {
  final String title;
  final GestureTapCallback? tapCallback;
  final AlertActionType type;
  const AlertAction({
    super.key,
    required this.title,
    this.tapCallback,
    this.type = AlertActionType.normal,
  });

  @override
  Widget build(BuildContext context) {
    return Expanded(
      child: GestureTapWidget(
        onTap: tapCallback,
        child: Container(
          height: 35,
          alignment: Alignment.center,
          decoration: type == AlertActionType.normal
              ? normalDecoration
              : lightDecoration,
          child: Text(
            title,
            style: type == AlertActionType.normal ? normalStyle : lightStyle,
          ),
        ),
      ),
    );
  }

  TextStyle get normalStyle => TextStyle(
        color: StyleParams.themeColor,
        fontSize: 15,
        fontWeight: FontWeight.w400,
      );

  TextStyle get lightStyle => TextStyle(
        color: Colors.white,
        fontSize: 15,
        fontWeight: FontWeight.w400,
      );

  BoxDecoration get normalDecoration => BoxDecoration(
        borderRadius: BorderRadius.circular(4),
        border: Border.all(color: StyleParams.themeColor, width: 1),
      );

  BoxDecoration get lightDecoration => BoxDecoration(
        borderRadius: BorderRadius.circular(4),
        color: StyleParams.themeColor,
      );
}
