import 'package:account_center/account_center.dart';
import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

import '../company_manage_logic.dart';
import './custom_line.dart';

class CompanyInfo extends StatelessWidget {
  final CompanyManageLogic logic;
  const CompanyInfo({super.key, required this.logic});

  @override
  Widget build(BuildContext context) {
    /// 最外层不规则矩形
    return CustomPaint(
      painter: CustomLine(StyleParams.themeColor, 20, 0),
      child: Container(
        padding: const EdgeInsets.only(left: 15, top: 15, right: 15),
        child: CustomPaint(
          /// 最内侧不规则矩形
          painter: CustomLine(Color(0xff3C3F53), 18, 18),
          child: Container(
            padding: const EdgeInsets.only(left: 16, top: 23, bottom: 46),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.vertical(top: Radius.circular(18)),
            ),
            child: Row(
              children: [
                /// 公司Logo
                ImageLoad.companyLogo(logic.companyLogo, width: 42, height: 42),
                hGap10,

                /// 公司名称&地址
                Expanded(
                    child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(
                      logic.companyName,
                      overflow: TextOverflow.ellipsis,
                      maxLines: 1,
                      style: TextStyle(
                        color: Color(0xffFFDEB9),
                        fontSize: 16.0,
                        fontWeight: FontWeight.w500,
                      ),
                    ),
                    vGap9,
                    Text(
                      logic.companyAddress,
                      style: TextStyle(
                        color: Color(0xffFFDDB4),
                        fontSize: 12.0,
                        fontWeight: FontWeight.w400,
                      ),
                    )
                  ],
                )),

                /// 企业信息
                Visibility(
                  visible: hasMenuPermission('btn_company_info'),
                  child: GestureTapWidget(
                    onTap: () {
                      Get.toNamed(RouteConfig.enterpriseSeePage,
                          arguments: {'companyNo': getCompanyNo(), 'type': 1});
                    },
                    child: Container(
                      padding: const EdgeInsets.only(
                          left: 18, top: 10, bottom: 10, right: 10),
                      decoration: BoxDecoration(
                        gradient: LinearGradient(
                          colors: [
                            Color.fromRGBO(255, 255, 255, 0),
                            Color.fromRGBO(255, 255, 255, 0.2)
                          ],
                        ),
                      ),
                      child: Row(
                        children: [
                          Text(
                            '企业信息',
                            style: TextStyle(
                                color: Color(0xffFFDEB9),
                                fontSize: 14,
                                fontWeight: FontWeight.w400),
                          ),
                          Icon(
                            Icons.navigate_next_rounded,
                            color: Color(0xffFFDEB9),
                            size: 14,
                          )
                        ],
                      ),
                    ),
                  ),
                )
              ],
            ),
          ),
        ),
      ),
    );
  }
}
