import 'package:account_center/account_center.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:flutter/material.dart';

import '../company_manage_logic.dart';

class Authentication extends StatelessWidget {
  final CompanyManageLogic logic;

  const Authentication({super.key, required this.logic});

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.symmetric(horizontal: 15, vertical: 10),
      padding: const EdgeInsets.all(16),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8),
        gradient: LinearGradient(
          colors: [Color(0xffFEE8B9), Color(0xffF4D398)],
        ),
      ),
      child: Row(
        children: [
          ImageLoad.loadAssertImage('company_home_auth', width: 24, height: 24),
          hGap8,
          Expanded(
            child: Text(
              '立即认证，享受更多权益',
              style: TextStyle(
                color: Color(0xff512C19),
                fontSize: 14,
                fontWeight: FontWeight.w500,
              ),
            ),
          ),
          hGap8,
          GestureTapWidget(
            onTap: logic.companyAuthAction,
            child: Row(
              children: [
                Text(
                  '立即认证',
                  style: TextStyle(
                    color: Color(0xff512C19),
                    fontSize: 12,
                    fontWeight: FontWeight.w500,
                  ),
                ),
                hGap8,
                Container(
                  width: 15,
                  height: 15,
                  decoration: BoxDecoration(
                    color: Color(0xff512C19),
                    borderRadius: BorderRadius.circular(7.5),
                  ),
                  alignment: Alignment.center,
                  child: Icon(
                    Icons.navigate_next_rounded,
                    color: Color(0xffF4D398),
                    size: 15,
                  ),
                ),
              ],
            ),
          )
        ],
      ),
    );
  }
}
