import 'package:account_center/account_center.dart';
import 'package:flutter/material.dart';

class GuideStepItem extends StatelessWidget {
  final String title;
  final String detail;

  const GuideStepItem({super.key, required this.title, this.detail = ''});

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.only(top: 5),
      padding: const EdgeInsets.all(15),
      width: double.infinity,
      decoration: BoxDecoration(
        color: Color(0xffF3F6FA),
        borderRadius: BorderRadius.circular(4),
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            title,
            style: TextStyle(
                color: Color(0xff171A1D),
                fontSize: 14,
                fontWeight: FontWeight.w500),
          ),
          vGap8,
          Text(
            detail,
            style: TextStyle(
                color: Color(0xff88909B),
                fontSize: 14,
                fontWeight: FontWeight.w400),
          ),
        ],
      ),
    );
  }
}
